@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.ApplicationServerFullResourceNamesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The full resource names object for application layer resources. The number of entries in this list should be equal to the number VMs to be created for application layer.
 * @property availabilitySetName The full name for availability set. In case name is not provided, it will be defaulted to {SID}-App-AvSet.
 * @property virtualMachines The list of virtual machine naming details.
 */
public data class ApplicationServerFullResourceNamesArgs(
    public val availabilitySetName: Output<String>? = null,
    public val virtualMachines: Output<List<VirtualMachineResourceNamesArgs>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.ApplicationServerFullResourceNamesArgs> {
    override fun toJava():
        com.pulumi.azurenative.workloads.inputs.ApplicationServerFullResourceNamesArgs =
        com.pulumi.azurenative.workloads.inputs.ApplicationServerFullResourceNamesArgs.builder()
            .availabilitySetName(availabilitySetName?.applyValue({ args0 -> args0 }))
            .virtualMachines(
                virtualMachines?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ApplicationServerFullResourceNamesArgs].
 */
@PulumiTagMarker
public class ApplicationServerFullResourceNamesArgsBuilder internal constructor() {
    private var availabilitySetName: Output<String>? = null

    private var virtualMachines: Output<List<VirtualMachineResourceNamesArgs>>? = null

    /**
     * @param value The full name for availability set. In case name is not provided, it will be defaulted to {SID}-App-AvSet.
     */
    @JvmName("dgbkfuwlehldglqk")
    public suspend fun availabilitySetName(`value`: Output<String>) {
        this.availabilitySetName = value
    }

    /**
     * @param value The list of virtual machine naming details.
     */
    @JvmName("wjilhvvfkbyktcrf")
    public suspend fun virtualMachines(`value`: Output<List<VirtualMachineResourceNamesArgs>>) {
        this.virtualMachines = value
    }

    @JvmName("pnwcrwyheamnurds")
    public suspend fun virtualMachines(vararg values: Output<VirtualMachineResourceNamesArgs>) {
        this.virtualMachines = Output.all(values.asList())
    }

    /**
     * @param values The list of virtual machine naming details.
     */
    @JvmName("qwtcupxfedaqnuoe")
    public suspend fun virtualMachines(values: List<Output<VirtualMachineResourceNamesArgs>>) {
        this.virtualMachines = Output.all(values)
    }

    /**
     * @param value The full name for availability set. In case name is not provided, it will be defaulted to {SID}-App-AvSet.
     */
    @JvmName("ebtbtrosrrxswlom")
    public suspend fun availabilitySetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilitySetName = mapped
    }

    /**
     * @param value The list of virtual machine naming details.
     */
    @JvmName("cqjeuvrlgulwdket")
    public suspend fun virtualMachines(`value`: List<VirtualMachineResourceNamesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualMachines = mapped
    }

    /**
     * @param argument The list of virtual machine naming details.
     */
    @JvmName("hfyunvebudrmheae")
    public suspend
    fun virtualMachines(argument: List<suspend VirtualMachineResourceNamesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VirtualMachineResourceNamesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.virtualMachines = mapped
    }

    /**
     * @param argument The list of virtual machine naming details.
     */
    @JvmName("bsoydiabjomhuhfq")
    public suspend fun virtualMachines(
        vararg
        argument: suspend VirtualMachineResourceNamesArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            VirtualMachineResourceNamesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.virtualMachines = mapped
    }

    /**
     * @param argument The list of virtual machine naming details.
     */
    @JvmName("rfgaiqyacmffwfgl")
    public suspend
    fun virtualMachines(argument: suspend VirtualMachineResourceNamesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            VirtualMachineResourceNamesArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.virtualMachines = mapped
    }

    /**
     * @param values The list of virtual machine naming details.
     */
    @JvmName("nbkivxiealauqkwp")
    public suspend fun virtualMachines(vararg values: VirtualMachineResourceNamesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.virtualMachines = mapped
    }

    internal fun build(): ApplicationServerFullResourceNamesArgs =
        ApplicationServerFullResourceNamesArgs(
            availabilitySetName = availabilitySetName,
            virtualMachines = virtualMachines,
        )
}
