@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.DB2ProviderInstancePropertiesArgs.builder
import com.pulumi.azurenative.workloads.kotlin.enums.SslPreference
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Gets or sets the DB2 provider properties.
 * @property dbName Gets or sets the db2 database name.
 * @property dbPassword Gets or sets the db2 database password.
 * @property dbPasswordUri Gets or sets the key vault URI to secret with the database password.
 * @property dbPort Gets or sets the db2 database sql port.
 * @property dbUsername Gets or sets the db2 database user name.
 * @property hostname Gets or sets the target virtual machine name.
 * @property providerType The provider type. For example, the value can be SapHana.
 * Expected value is 'Db2'.
 * @property sapSid Gets or sets the SAP System Identifier
 * @property sslCertificateUri Gets or sets the blob URI to SSL certificate for the DB2 Database.
 * @property sslPreference Gets or sets certificate preference if secure communication is enabled.
 */
public data class DB2ProviderInstancePropertiesArgs(
    public val dbName: Output<String>? = null,
    public val dbPassword: Output<String>? = null,
    public val dbPasswordUri: Output<String>? = null,
    public val dbPort: Output<String>? = null,
    public val dbUsername: Output<String>? = null,
    public val hostname: Output<String>? = null,
    public val providerType: Output<String>,
    public val sapSid: Output<String>? = null,
    public val sslCertificateUri: Output<String>? = null,
    public val sslPreference: Output<Either<String, SslPreference>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.DB2ProviderInstancePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.inputs.DB2ProviderInstancePropertiesArgs =
        com.pulumi.azurenative.workloads.inputs.DB2ProviderInstancePropertiesArgs.builder()
            .dbName(dbName?.applyValue({ args0 -> args0 }))
            .dbPassword(dbPassword?.applyValue({ args0 -> args0 }))
            .dbPasswordUri(dbPasswordUri?.applyValue({ args0 -> args0 }))
            .dbPort(dbPort?.applyValue({ args0 -> args0 }))
            .dbUsername(dbUsername?.applyValue({ args0 -> args0 }))
            .hostname(hostname?.applyValue({ args0 -> args0 }))
            .providerType(providerType.applyValue({ args0 -> args0 }))
            .sapSid(sapSid?.applyValue({ args0 -> args0 }))
            .sslCertificateUri(sslCertificateUri?.applyValue({ args0 -> args0 }))
            .sslPreference(
                sslPreference?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [DB2ProviderInstancePropertiesArgs].
 */
@PulumiTagMarker
public class DB2ProviderInstancePropertiesArgsBuilder internal constructor() {
    private var dbName: Output<String>? = null

    private var dbPassword: Output<String>? = null

    private var dbPasswordUri: Output<String>? = null

    private var dbPort: Output<String>? = null

    private var dbUsername: Output<String>? = null

    private var hostname: Output<String>? = null

    private var providerType: Output<String>? = null

    private var sapSid: Output<String>? = null

    private var sslCertificateUri: Output<String>? = null

    private var sslPreference: Output<Either<String, SslPreference>>? = null

    /**
     * @param value Gets or sets the db2 database name.
     */
    @JvmName("nymlflqpvtntahvr")
    public suspend fun dbName(`value`: Output<String>) {
        this.dbName = value
    }

    /**
     * @param value Gets or sets the db2 database password.
     */
    @JvmName("voilgcdfnpfecrgj")
    public suspend fun dbPassword(`value`: Output<String>) {
        this.dbPassword = value
    }

    /**
     * @param value Gets or sets the key vault URI to secret with the database password.
     */
    @JvmName("mmbdywavhcmurkxf")
    public suspend fun dbPasswordUri(`value`: Output<String>) {
        this.dbPasswordUri = value
    }

    /**
     * @param value Gets or sets the db2 database sql port.
     */
    @JvmName("govgtglyqvmujpbk")
    public suspend fun dbPort(`value`: Output<String>) {
        this.dbPort = value
    }

    /**
     * @param value Gets or sets the db2 database user name.
     */
    @JvmName("ffntlopcotvfshgk")
    public suspend fun dbUsername(`value`: Output<String>) {
        this.dbUsername = value
    }

    /**
     * @param value Gets or sets the target virtual machine name.
     */
    @JvmName("nbofmjulvmljnwff")
    public suspend fun hostname(`value`: Output<String>) {
        this.hostname = value
    }

    /**
     * @param value The provider type. For example, the value can be SapHana.
     * Expected value is 'Db2'.
     */
    @JvmName("avjuaxadpdkqsxtr")
    public suspend fun providerType(`value`: Output<String>) {
        this.providerType = value
    }

    /**
     * @param value Gets or sets the SAP System Identifier
     */
    @JvmName("yaacdvabehlargun")
    public suspend fun sapSid(`value`: Output<String>) {
        this.sapSid = value
    }

    /**
     * @param value Gets or sets the blob URI to SSL certificate for the DB2 Database.
     */
    @JvmName("hnoiaoakvedmxahn")
    public suspend fun sslCertificateUri(`value`: Output<String>) {
        this.sslCertificateUri = value
    }

    /**
     * @param value Gets or sets certificate preference if secure communication is enabled.
     */
    @JvmName("dvlxwsqdfvmijnyk")
    public suspend fun sslPreference(`value`: Output<Either<String, SslPreference>>) {
        this.sslPreference = value
    }

    /**
     * @param value Gets or sets the db2 database name.
     */
    @JvmName("gwnnaecnjkkuhnbw")
    public suspend fun dbName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbName = mapped
    }

    /**
     * @param value Gets or sets the db2 database password.
     */
    @JvmName("sagnelvysgpusiml")
    public suspend fun dbPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbPassword = mapped
    }

    /**
     * @param value Gets or sets the key vault URI to secret with the database password.
     */
    @JvmName("onehvrjtbuuuovyg")
    public suspend fun dbPasswordUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbPasswordUri = mapped
    }

    /**
     * @param value Gets or sets the db2 database sql port.
     */
    @JvmName("hdrtncdxucnbktnj")
    public suspend fun dbPort(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbPort = mapped
    }

    /**
     * @param value Gets or sets the db2 database user name.
     */
    @JvmName("lkjddrcxasjulbbe")
    public suspend fun dbUsername(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbUsername = mapped
    }

    /**
     * @param value Gets or sets the target virtual machine name.
     */
    @JvmName("onktsjbvnugqywpi")
    public suspend fun hostname(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostname = mapped
    }

    /**
     * @param value The provider type. For example, the value can be SapHana.
     * Expected value is 'Db2'.
     */
    @JvmName("unbqngwuapwqdsos")
    public suspend fun providerType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.providerType = mapped
    }

    /**
     * @param value Gets or sets the SAP System Identifier
     */
    @JvmName("sxeusxgwcfumjpco")
    public suspend fun sapSid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sapSid = mapped
    }

    /**
     * @param value Gets or sets the blob URI to SSL certificate for the DB2 Database.
     */
    @JvmName("ojvirsovxsbgfbho")
    public suspend fun sslCertificateUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sslCertificateUri = mapped
    }

    /**
     * @param value Gets or sets certificate preference if secure communication is enabled.
     */
    @JvmName("rwbathyhtdwfxitc")
    public suspend fun sslPreference(`value`: Either<String, SslPreference>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sslPreference = mapped
    }

    /**
     * @param value Gets or sets certificate preference if secure communication is enabled.
     */
    @JvmName("mphugxncimfybvkx")
    public fun sslPreference(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SslPreference>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sslPreference = mapped
    }

    /**
     * @param value Gets or sets certificate preference if secure communication is enabled.
     */
    @JvmName("qxnrpkweamhabyui")
    public fun sslPreference(`value`: SslPreference) {
        val toBeMapped = Either.ofRight<String, SslPreference>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sslPreference = mapped
    }

    internal fun build(): DB2ProviderInstancePropertiesArgs = DB2ProviderInstancePropertiesArgs(
        dbName = dbName,
        dbPassword = dbPassword,
        dbPasswordUri = dbPasswordUri,
        dbPort = dbPort,
        dbUsername = dbUsername,
        hostname = hostname,
        providerType = providerType ?: throw PulumiNullFieldException("providerType"),
        sapSid = sapSid,
        sslCertificateUri = sslCertificateUri,
        sslPreference = sslPreference,
    )
}
