@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.DeploymentWithOSConfigurationArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Deployment along with OS Configuration.
 * @property appLocation The geo-location where the SAP system is to be created.
 * @property configurationType The configuration Type.
 * Expected value is 'DeploymentWithOSConfig'.
 * @property infrastructureConfiguration The infrastructure configuration.
 * @property osSapConfiguration The OS and SAP configuration.
 * @property softwareConfiguration The software configuration.
 */
public data class DeploymentWithOSConfigurationArgs(
    public val appLocation: Output<String>? = null,
    public val configurationType: Output<String>,
    public val infrastructureConfiguration:
    Output<Either<SingleServerConfigurationArgs, ThreeTierConfigurationArgs>>? = null,
    public val osSapConfiguration: Output<OsSapConfigurationArgs>? = null,
    public val softwareConfiguration: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.DeploymentWithOSConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.inputs.DeploymentWithOSConfigurationArgs =
        com.pulumi.azurenative.workloads.inputs.DeploymentWithOSConfigurationArgs.builder()
            .appLocation(appLocation?.applyValue({ args0 -> args0 }))
            .configurationType(configurationType.applyValue({ args0 -> args0 }))
            .infrastructureConfiguration(
                infrastructureConfiguration?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0.let({ args0 -> args0.toJava() }) }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .osSapConfiguration(
                osSapConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .softwareConfiguration(softwareConfiguration?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DeploymentWithOSConfigurationArgs].
 */
@PulumiTagMarker
public class DeploymentWithOSConfigurationArgsBuilder internal constructor() {
    private var appLocation: Output<String>? = null

    private var configurationType: Output<String>? = null

    private var infrastructureConfiguration:
        Output<Either<SingleServerConfigurationArgs, ThreeTierConfigurationArgs>>? = null

    private var osSapConfiguration: Output<OsSapConfigurationArgs>? = null

    private var softwareConfiguration: Output<Any>? = null

    /**
     * @param value The geo-location where the SAP system is to be created.
     */
    @JvmName("tcvptrrrsoxbilun")
    public suspend fun appLocation(`value`: Output<String>) {
        this.appLocation = value
    }

    /**
     * @param value The configuration Type.
     * Expected value is 'DeploymentWithOSConfig'.
     */
    @JvmName("edrtvtuvrdgltcvs")
    public suspend fun configurationType(`value`: Output<String>) {
        this.configurationType = value
    }

    /**
     * @param value The infrastructure configuration.
     */
    @JvmName("gsbkifeejnhssjun")
    public suspend
    fun infrastructureConfiguration(`value`: Output<Either<SingleServerConfigurationArgs, ThreeTierConfigurationArgs>>) {
        this.infrastructureConfiguration = value
    }

    /**
     * @param value The OS and SAP configuration.
     */
    @JvmName("wsfowssrwikegfsr")
    public suspend fun osSapConfiguration(`value`: Output<OsSapConfigurationArgs>) {
        this.osSapConfiguration = value
    }

    /**
     * @param value The software configuration.
     */
    @JvmName("adbjgkerimbfioig")
    public suspend fun softwareConfiguration(`value`: Output<Any>) {
        this.softwareConfiguration = value
    }

    /**
     * @param value The geo-location where the SAP system is to be created.
     */
    @JvmName("scwqwwmdehjghtoq")
    public suspend fun appLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appLocation = mapped
    }

    /**
     * @param value The configuration Type.
     * Expected value is 'DeploymentWithOSConfig'.
     */
    @JvmName("pssxbaihcespagrx")
    public suspend fun configurationType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configurationType = mapped
    }

    /**
     * @param value The infrastructure configuration.
     */
    @JvmName("lditsferugqvvbjh")
    public suspend
    fun infrastructureConfiguration(`value`: Either<SingleServerConfigurationArgs, ThreeTierConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.infrastructureConfiguration = mapped
    }

    /**
     * @param value The infrastructure configuration.
     */
    @JvmName("fqhafpnotrdjukun")
    public fun infrastructureConfiguration(`value`: SingleServerConfigurationArgs) {
        val toBeMapped = Either.ofLeft<SingleServerConfigurationArgs, ThreeTierConfigurationArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.infrastructureConfiguration = mapped
    }

    /**
     * @param value The infrastructure configuration.
     */
    @JvmName("gxyuspvjdiamwpgh")
    public fun infrastructureConfiguration(`value`: ThreeTierConfigurationArgs) {
        val toBeMapped = Either.ofRight<SingleServerConfigurationArgs,
            ThreeTierConfigurationArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.infrastructureConfiguration = mapped
    }

    /**
     * @param value The OS and SAP configuration.
     */
    @JvmName("coutdqdmytsrvsra")
    public suspend fun osSapConfiguration(`value`: OsSapConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.osSapConfiguration = mapped
    }

    /**
     * @param argument The OS and SAP configuration.
     */
    @JvmName("iglkgeyoptintfnn")
    public suspend
    fun osSapConfiguration(argument: suspend OsSapConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = OsSapConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.osSapConfiguration = mapped
    }

    /**
     * @param value The software configuration.
     */
    @JvmName("ytqbsyuvdgvhnvhq")
    public suspend fun softwareConfiguration(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.softwareConfiguration = mapped
    }

    internal fun build(): DeploymentWithOSConfigurationArgs = DeploymentWithOSConfigurationArgs(
        appLocation = appLocation,
        configurationType = configurationType ?: throw PulumiNullFieldException("configurationType"),
        infrastructureConfiguration = infrastructureConfiguration,
        osSapConfiguration = osSapConfiguration,
        softwareConfiguration = softwareConfiguration,
    )
}
