@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.DiskSkuArgs.builder
import com.pulumi.azurenative.workloads.kotlin.enums.DiskSkuName
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The type of disk sku. For example, Standard_LRS, Standard_ZRS, Premium_LRS, Premium_ZRS.
 * @property name Defines the disk sku name.
 */
public data class DiskSkuArgs(
    public val name: Output<Either<String, DiskSkuName>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.DiskSkuArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.inputs.DiskSkuArgs =
        com.pulumi.azurenative.workloads.inputs.DiskSkuArgs.builder()
            .name(
                name?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [DiskSkuArgs].
 */
@PulumiTagMarker
public class DiskSkuArgsBuilder internal constructor() {
    private var name: Output<Either<String, DiskSkuName>>? = null

    /**
     * @param value Defines the disk sku name.
     */
    @JvmName("bpyiypaeafcrufij")
    public suspend fun name(`value`: Output<Either<String, DiskSkuName>>) {
        this.name = value
    }

    /**
     * @param value Defines the disk sku name.
     */
    @JvmName("mardxfcyxupfnloh")
    public suspend fun name(`value`: Either<String, DiskSkuName>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Defines the disk sku name.
     */
    @JvmName("mlvdrvcxqtkyyllf")
    public fun name(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DiskSkuName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Defines the disk sku name.
     */
    @JvmName("djpkhbjnbwxvtofu")
    public fun name(`value`: DiskSkuName) {
        val toBeMapped = Either.ofRight<String, DiskSkuName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): DiskSkuArgs = DiskSkuArgs(
        name = name,
    )
}
