@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.GetProviderInstancePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property monitorName Name of the SAP monitor resource.
 * @property providerInstanceName Name of the provider instance.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetProviderInstancePlainArgs(
    public val monitorName: String,
    public val providerInstanceName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.GetProviderInstancePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.inputs.GetProviderInstancePlainArgs =
        com.pulumi.azurenative.workloads.inputs.GetProviderInstancePlainArgs.builder()
            .monitorName(monitorName.let({ args0 -> args0 }))
            .providerInstanceName(providerInstanceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetProviderInstancePlainArgs].
 */
@PulumiTagMarker
public class GetProviderInstancePlainArgsBuilder internal constructor() {
    private var monitorName: String? = null

    private var providerInstanceName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the SAP monitor resource.
     */
    @JvmName("nktvjknjpsnbspen")
    public suspend fun monitorName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.monitorName = mapped
    }

    /**
     * @param value Name of the provider instance.
     */
    @JvmName("ndwwbnycsfvwllif")
    public suspend fun providerInstanceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.providerInstanceName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("erakvftywcolkwmf")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetProviderInstancePlainArgs = GetProviderInstancePlainArgs(
        monitorName = monitorName ?: throw PulumiNullFieldException("monitorName"),
        providerInstanceName = providerInstanceName ?: throw
            PulumiNullFieldException("providerInstanceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
