@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.GetSAPApplicationServerInstancePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property applicationInstanceName The name of SAP Application Server instance resource.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sapVirtualInstanceName The name of the Virtual Instances for SAP solutions resource
 */
public data class GetSAPApplicationServerInstancePlainArgs(
    public val applicationInstanceName: String,
    public val resourceGroupName: String,
    public val sapVirtualInstanceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.GetSAPApplicationServerInstancePlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.workloads.inputs.GetSAPApplicationServerInstancePlainArgs =
        com.pulumi.azurenative.workloads.inputs.GetSAPApplicationServerInstancePlainArgs.builder()
            .applicationInstanceName(applicationInstanceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .sapVirtualInstanceName(sapVirtualInstanceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSAPApplicationServerInstancePlainArgs].
 */
@PulumiTagMarker
public class GetSAPApplicationServerInstancePlainArgsBuilder internal constructor() {
    private var applicationInstanceName: String? = null

    private var resourceGroupName: String? = null

    private var sapVirtualInstanceName: String? = null

    /**
     * @param value The name of SAP Application Server instance resource.
     */
    @JvmName("fhapfjwknitucfvw")
    public suspend fun applicationInstanceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.applicationInstanceName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("pwaxoxhwfodqdwap")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Virtual Instances for SAP solutions resource
     */
    @JvmName("kpahtshnnbmidiqg")
    public suspend fun sapVirtualInstanceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sapVirtualInstanceName = mapped
    }

    internal fun build(): GetSAPApplicationServerInstancePlainArgs =
        GetSAPApplicationServerInstancePlainArgs(
            applicationInstanceName = applicationInstanceName ?: throw
                PulumiNullFieldException("applicationInstanceName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            sapVirtualInstanceName = sapVirtualInstanceName ?: throw
                PulumiNullFieldException("sapVirtualInstanceName"),
        )
}
