@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.GetSAPVirtualInstancePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sapVirtualInstanceName The name of the Virtual Instances for SAP solutions resource
 */
public data class GetSAPVirtualInstancePlainArgs(
    public val resourceGroupName: String,
    public val sapVirtualInstanceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.GetSAPVirtualInstancePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.inputs.GetSAPVirtualInstancePlainArgs =
        com.pulumi.azurenative.workloads.inputs.GetSAPVirtualInstancePlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .sapVirtualInstanceName(sapVirtualInstanceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSAPVirtualInstancePlainArgs].
 */
@PulumiTagMarker
public class GetSAPVirtualInstancePlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var sapVirtualInstanceName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qqbhgdhswtuxwduh")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Virtual Instances for SAP solutions resource
     */
    @JvmName("nsiqapgiitcacxlm")
    public suspend fun sapVirtualInstanceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sapVirtualInstanceName = mapped
    }

    internal fun build(): GetSAPVirtualInstancePlainArgs = GetSAPVirtualInstancePlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        sapVirtualInstanceName = sapVirtualInstanceName ?: throw
            PulumiNullFieldException("sapVirtualInstanceName"),
    )
}
