@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.HighAvailabilityConfigurationArgs.builder
import com.pulumi.azurenative.workloads.kotlin.enums.SAPHighAvailabilityType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Gets or sets the high availability configuration.
 * @property highAvailabilityType The high availability type.
 */
public data class HighAvailabilityConfigurationArgs(
    public val highAvailabilityType: Output<Either<String, SAPHighAvailabilityType>>,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.HighAvailabilityConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.inputs.HighAvailabilityConfigurationArgs =
        com.pulumi.azurenative.workloads.inputs.HighAvailabilityConfigurationArgs.builder()
            .highAvailabilityType(
                highAvailabilityType.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            ).build()
}

/**
 * Builder for [HighAvailabilityConfigurationArgs].
 */
@PulumiTagMarker
public class HighAvailabilityConfigurationArgsBuilder internal constructor() {
    private var highAvailabilityType: Output<Either<String, SAPHighAvailabilityType>>? = null

    /**
     * @param value The high availability type.
     */
    @JvmName("oqevryjhnhkvhmcg")
    public suspend
    fun highAvailabilityType(`value`: Output<Either<String, SAPHighAvailabilityType>>) {
        this.highAvailabilityType = value
    }

    /**
     * @param value The high availability type.
     */
    @JvmName("ssilvltineumrpmb")
    public suspend fun highAvailabilityType(`value`: Either<String, SAPHighAvailabilityType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.highAvailabilityType = mapped
    }

    /**
     * @param value The high availability type.
     */
    @JvmName("ucavireyunsmwqki")
    public fun highAvailabilityType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SAPHighAvailabilityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.highAvailabilityType = mapped
    }

    /**
     * @param value The high availability type.
     */
    @JvmName("wmrdrniaohcfcfsg")
    public fun highAvailabilityType(`value`: SAPHighAvailabilityType) {
        val toBeMapped = Either.ofRight<String, SAPHighAvailabilityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.highAvailabilityType = mapped
    }

    internal fun build(): HighAvailabilityConfigurationArgs = HighAvailabilityConfigurationArgs(
        highAvailabilityType = highAvailabilityType ?: throw
            PulumiNullFieldException("highAvailabilityType"),
    )
}
