@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.PrometheusOSProviderInstancePropertiesArgs.builder
import com.pulumi.azurenative.workloads.kotlin.enums.SslPreference
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Gets or sets the PrometheusOS provider properties.
 * @property prometheusUrl URL of the Node Exporter endpoint
 * @property providerType The provider type. For example, the value can be SapHana.
 * Expected value is 'PrometheusOS'.
 * @property sapSid Gets or sets the SAP System Identifier
 * @property sslCertificateUri Gets or sets the blob URI to SSL certificate for the prometheus node exporter.
 * @property sslPreference Gets or sets certificate preference if secure communication is enabled.
 */
public data class PrometheusOSProviderInstancePropertiesArgs(
    public val prometheusUrl: Output<String>? = null,
    public val providerType: Output<String>,
    public val sapSid: Output<String>? = null,
    public val sslCertificateUri: Output<String>? = null,
    public val sslPreference: Output<Either<String, SslPreference>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.PrometheusOSProviderInstancePropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.workloads.inputs.PrometheusOSProviderInstancePropertiesArgs =
        com.pulumi.azurenative.workloads.inputs.PrometheusOSProviderInstancePropertiesArgs.builder()
            .prometheusUrl(prometheusUrl?.applyValue({ args0 -> args0 }))
            .providerType(providerType.applyValue({ args0 -> args0 }))
            .sapSid(sapSid?.applyValue({ args0 -> args0 }))
            .sslCertificateUri(sslCertificateUri?.applyValue({ args0 -> args0 }))
            .sslPreference(
                sslPreference?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [PrometheusOSProviderInstancePropertiesArgs].
 */
@PulumiTagMarker
public class PrometheusOSProviderInstancePropertiesArgsBuilder internal constructor() {
    private var prometheusUrl: Output<String>? = null

    private var providerType: Output<String>? = null

    private var sapSid: Output<String>? = null

    private var sslCertificateUri: Output<String>? = null

    private var sslPreference: Output<Either<String, SslPreference>>? = null

    /**
     * @param value URL of the Node Exporter endpoint
     */
    @JvmName("abulxonaovmvahjm")
    public suspend fun prometheusUrl(`value`: Output<String>) {
        this.prometheusUrl = value
    }

    /**
     * @param value The provider type. For example, the value can be SapHana.
     * Expected value is 'PrometheusOS'.
     */
    @JvmName("dsegvyfulkyggoch")
    public suspend fun providerType(`value`: Output<String>) {
        this.providerType = value
    }

    /**
     * @param value Gets or sets the SAP System Identifier
     */
    @JvmName("tdavjafweogiykoj")
    public suspend fun sapSid(`value`: Output<String>) {
        this.sapSid = value
    }

    /**
     * @param value Gets or sets the blob URI to SSL certificate for the prometheus node exporter.
     */
    @JvmName("cjirvgephsqxmlwm")
    public suspend fun sslCertificateUri(`value`: Output<String>) {
        this.sslCertificateUri = value
    }

    /**
     * @param value Gets or sets certificate preference if secure communication is enabled.
     */
    @JvmName("twlhojamycpvxdeu")
    public suspend fun sslPreference(`value`: Output<Either<String, SslPreference>>) {
        this.sslPreference = value
    }

    /**
     * @param value URL of the Node Exporter endpoint
     */
    @JvmName("vfnxqqahkomxreyb")
    public suspend fun prometheusUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prometheusUrl = mapped
    }

    /**
     * @param value The provider type. For example, the value can be SapHana.
     * Expected value is 'PrometheusOS'.
     */
    @JvmName("copxgpbtrumejsrn")
    public suspend fun providerType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.providerType = mapped
    }

    /**
     * @param value Gets or sets the SAP System Identifier
     */
    @JvmName("jawhfjqkkgcgklrp")
    public suspend fun sapSid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sapSid = mapped
    }

    /**
     * @param value Gets or sets the blob URI to SSL certificate for the prometheus node exporter.
     */
    @JvmName("acperthoudmkpmvr")
    public suspend fun sslCertificateUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sslCertificateUri = mapped
    }

    /**
     * @param value Gets or sets certificate preference if secure communication is enabled.
     */
    @JvmName("ytfohhrhcpejedsg")
    public suspend fun sslPreference(`value`: Either<String, SslPreference>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sslPreference = mapped
    }

    /**
     * @param value Gets or sets certificate preference if secure communication is enabled.
     */
    @JvmName("akxafcdihviahdgx")
    public fun sslPreference(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SslPreference>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sslPreference = mapped
    }

    /**
     * @param value Gets or sets certificate preference if secure communication is enabled.
     */
    @JvmName("rraheutuoxwxlmlr")
    public fun sslPreference(`value`: SslPreference) {
        val toBeMapped = Either.ofRight<String, SslPreference>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sslPreference = mapped
    }

    internal fun build(): PrometheusOSProviderInstancePropertiesArgs =
        PrometheusOSProviderInstancePropertiesArgs(
            prometheusUrl = prometheusUrl,
            providerType = providerType ?: throw PulumiNullFieldException("providerType"),
            sapSid = sapSid,
            sslCertificateUri = sslCertificateUri,
            sslPreference = sslPreference,
        )
}
