@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.SapLandscapeMonitorPropertiesGroupingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Gets or sets the SID groupings by landscape and Environment.
 * @property landscape Gets or sets the list of landscape to SID mappings.
 * @property sapApplication Gets or sets the list of Sap Applications to SID mappings.
 */
public data class SapLandscapeMonitorPropertiesGroupingArgs(
    public val landscape: Output<List<SapLandscapeMonitorSidMappingArgs>>? = null,
    public val sapApplication: Output<List<SapLandscapeMonitorSidMappingArgs>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.SapLandscapeMonitorPropertiesGroupingArgs> {
    override fun toJava():
        com.pulumi.azurenative.workloads.inputs.SapLandscapeMonitorPropertiesGroupingArgs =
        com.pulumi.azurenative.workloads.inputs.SapLandscapeMonitorPropertiesGroupingArgs.builder()
            .landscape(
                landscape?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .sapApplication(
                sapApplication?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [SapLandscapeMonitorPropertiesGroupingArgs].
 */
@PulumiTagMarker
public class SapLandscapeMonitorPropertiesGroupingArgsBuilder internal constructor() {
    private var landscape: Output<List<SapLandscapeMonitorSidMappingArgs>>? = null

    private var sapApplication: Output<List<SapLandscapeMonitorSidMappingArgs>>? = null

    /**
     * @param value Gets or sets the list of landscape to SID mappings.
     */
    @JvmName("qkugwcpeesdhgdax")
    public suspend fun landscape(`value`: Output<List<SapLandscapeMonitorSidMappingArgs>>) {
        this.landscape = value
    }

    @JvmName("wuokofetawlsyypb")
    public suspend fun landscape(vararg values: Output<SapLandscapeMonitorSidMappingArgs>) {
        this.landscape = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the list of landscape to SID mappings.
     */
    @JvmName("oyuprnkyvgijvggs")
    public suspend fun landscape(values: List<Output<SapLandscapeMonitorSidMappingArgs>>) {
        this.landscape = Output.all(values)
    }

    /**
     * @param value Gets or sets the list of Sap Applications to SID mappings.
     */
    @JvmName("fbknqhwshquyjtcy")
    public suspend fun sapApplication(`value`: Output<List<SapLandscapeMonitorSidMappingArgs>>) {
        this.sapApplication = value
    }

    @JvmName("jbenhaqhqtljfljg")
    public suspend fun sapApplication(vararg values: Output<SapLandscapeMonitorSidMappingArgs>) {
        this.sapApplication = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the list of Sap Applications to SID mappings.
     */
    @JvmName("qutnenodmhegcxuw")
    public suspend fun sapApplication(values: List<Output<SapLandscapeMonitorSidMappingArgs>>) {
        this.sapApplication = Output.all(values)
    }

    /**
     * @param value Gets or sets the list of landscape to SID mappings.
     */
    @JvmName("komjscnitrisbmae")
    public suspend fun landscape(`value`: List<SapLandscapeMonitorSidMappingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.landscape = mapped
    }

    /**
     * @param argument Gets or sets the list of landscape to SID mappings.
     */
    @JvmName("qlpjtyreikjsmvkv")
    public suspend
    fun landscape(argument: List<suspend SapLandscapeMonitorSidMappingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SapLandscapeMonitorSidMappingArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.landscape = mapped
    }

    /**
     * @param argument Gets or sets the list of landscape to SID mappings.
     */
    @JvmName("vfarmkupblpuwxov")
    public suspend fun landscape(
        vararg
        argument: suspend SapLandscapeMonitorSidMappingArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            SapLandscapeMonitorSidMappingArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.landscape = mapped
    }

    /**
     * @param argument Gets or sets the list of landscape to SID mappings.
     */
    @JvmName("hwiaxuwfxgpjihuq")
    public suspend
    fun landscape(argument: suspend SapLandscapeMonitorSidMappingArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            SapLandscapeMonitorSidMappingArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.landscape = mapped
    }

    /**
     * @param values Gets or sets the list of landscape to SID mappings.
     */
    @JvmName("inarqgblfmkcyylk")
    public suspend fun landscape(vararg values: SapLandscapeMonitorSidMappingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.landscape = mapped
    }

    /**
     * @param value Gets or sets the list of Sap Applications to SID mappings.
     */
    @JvmName("lwjgiacwverncfuf")
    public suspend fun sapApplication(`value`: List<SapLandscapeMonitorSidMappingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sapApplication = mapped
    }

    /**
     * @param argument Gets or sets the list of Sap Applications to SID mappings.
     */
    @JvmName("twwxtkyfkvdrnylv")
    public suspend
    fun sapApplication(argument: List<suspend SapLandscapeMonitorSidMappingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SapLandscapeMonitorSidMappingArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.sapApplication = mapped
    }

    /**
     * @param argument Gets or sets the list of Sap Applications to SID mappings.
     */
    @JvmName("xypdchsjjlxhsunx")
    public suspend fun sapApplication(
        vararg
        argument: suspend SapLandscapeMonitorSidMappingArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            SapLandscapeMonitorSidMappingArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.sapApplication = mapped
    }

    /**
     * @param argument Gets or sets the list of Sap Applications to SID mappings.
     */
    @JvmName("atbsumcufdgqbuwv")
    public suspend
    fun sapApplication(argument: suspend SapLandscapeMonitorSidMappingArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            SapLandscapeMonitorSidMappingArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.sapApplication = mapped
    }

    /**
     * @param values Gets or sets the list of Sap Applications to SID mappings.
     */
    @JvmName("gfqwrtkljhshwqyt")
    public suspend fun sapApplication(vararg values: SapLandscapeMonitorSidMappingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sapApplication = mapped
    }

    internal fun build(): SapLandscapeMonitorPropertiesGroupingArgs =
        SapLandscapeMonitorPropertiesGroupingArgs(
            landscape = landscape,
            sapApplication = sapApplication,
        )
}
