@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.ServiceInitiatedSoftwareConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The SAP Software configuration Input when the software is to be installed by service.
 * @property bomUrl The URL to the SAP Build of Materials(BOM) file.
 * @property highAvailabilitySoftwareConfiguration Gets or sets the HA software configuration.
 * @property sapBitsStorageAccountId The SAP bits storage account id.
 * @property sapFqdn The FQDN to set for the SAP system during install.
 * @property softwareInstallationType The SAP software installation Type.
 * Expected value is 'ServiceInitiated'.
 * @property softwareVersion The software version to install.
 * @property sshPrivateKey The SSH private key.
 */
public data class ServiceInitiatedSoftwareConfigurationArgs(
    public val bomUrl: Output<String>,
    public val highAvailabilitySoftwareConfiguration:
    Output<HighAvailabilitySoftwareConfigurationArgs>? = null,
    public val sapBitsStorageAccountId: Output<String>,
    public val sapFqdn: Output<String>,
    public val softwareInstallationType: Output<String>,
    public val softwareVersion: Output<String>,
    public val sshPrivateKey: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.ServiceInitiatedSoftwareConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.workloads.inputs.ServiceInitiatedSoftwareConfigurationArgs =
        com.pulumi.azurenative.workloads.inputs.ServiceInitiatedSoftwareConfigurationArgs.builder()
            .bomUrl(bomUrl.applyValue({ args0 -> args0 }))
            .highAvailabilitySoftwareConfiguration(
                highAvailabilitySoftwareConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .sapBitsStorageAccountId(sapBitsStorageAccountId.applyValue({ args0 -> args0 }))
            .sapFqdn(sapFqdn.applyValue({ args0 -> args0 }))
            .softwareInstallationType(softwareInstallationType.applyValue({ args0 -> args0 }))
            .softwareVersion(softwareVersion.applyValue({ args0 -> args0 }))
            .sshPrivateKey(sshPrivateKey.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceInitiatedSoftwareConfigurationArgs].
 */
@PulumiTagMarker
public class ServiceInitiatedSoftwareConfigurationArgsBuilder internal constructor() {
    private var bomUrl: Output<String>? = null

    private var highAvailabilitySoftwareConfiguration:
        Output<HighAvailabilitySoftwareConfigurationArgs>? = null

    private var sapBitsStorageAccountId: Output<String>? = null

    private var sapFqdn: Output<String>? = null

    private var softwareInstallationType: Output<String>? = null

    private var softwareVersion: Output<String>? = null

    private var sshPrivateKey: Output<String>? = null

    /**
     * @param value The URL to the SAP Build of Materials(BOM) file.
     */
    @JvmName("alubjiwpswumlwte")
    public suspend fun bomUrl(`value`: Output<String>) {
        this.bomUrl = value
    }

    /**
     * @param value Gets or sets the HA software configuration.
     */
    @JvmName("pslltyuigvrfakeh")
    public suspend
    fun highAvailabilitySoftwareConfiguration(`value`: Output<HighAvailabilitySoftwareConfigurationArgs>) {
        this.highAvailabilitySoftwareConfiguration = value
    }

    /**
     * @param value The SAP bits storage account id.
     */
    @JvmName("bslqvpfcyplwrwfo")
    public suspend fun sapBitsStorageAccountId(`value`: Output<String>) {
        this.sapBitsStorageAccountId = value
    }

    /**
     * @param value The FQDN to set for the SAP system during install.
     */
    @JvmName("debubykvklykkqms")
    public suspend fun sapFqdn(`value`: Output<String>) {
        this.sapFqdn = value
    }

    /**
     * @param value The SAP software installation Type.
     * Expected value is 'ServiceInitiated'.
     */
    @JvmName("hhprnqehbwgeefoq")
    public suspend fun softwareInstallationType(`value`: Output<String>) {
        this.softwareInstallationType = value
    }

    /**
     * @param value The software version to install.
     */
    @JvmName("rxfdexspbbmjfetf")
    public suspend fun softwareVersion(`value`: Output<String>) {
        this.softwareVersion = value
    }

    /**
     * @param value The SSH private key.
     */
    @JvmName("feikluesthahprfi")
    public suspend fun sshPrivateKey(`value`: Output<String>) {
        this.sshPrivateKey = value
    }

    /**
     * @param value The URL to the SAP Build of Materials(BOM) file.
     */
    @JvmName("eddhwyjakwdlllba")
    public suspend fun bomUrl(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bomUrl = mapped
    }

    /**
     * @param value Gets or sets the HA software configuration.
     */
    @JvmName("yeeerlfmautwrgua")
    public suspend
    fun highAvailabilitySoftwareConfiguration(`value`: HighAvailabilitySoftwareConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.highAvailabilitySoftwareConfiguration = mapped
    }

    /**
     * @param argument Gets or sets the HA software configuration.
     */
    @JvmName("opojefbwvsbprvlx")
    public suspend
    fun highAvailabilitySoftwareConfiguration(argument: suspend HighAvailabilitySoftwareConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = HighAvailabilitySoftwareConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.highAvailabilitySoftwareConfiguration = mapped
    }

    /**
     * @param value The SAP bits storage account id.
     */
    @JvmName("hgojlkomnvdkeexo")
    public suspend fun sapBitsStorageAccountId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sapBitsStorageAccountId = mapped
    }

    /**
     * @param value The FQDN to set for the SAP system during install.
     */
    @JvmName("hhsaqtwywmfkbbru")
    public suspend fun sapFqdn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sapFqdn = mapped
    }

    /**
     * @param value The SAP software installation Type.
     * Expected value is 'ServiceInitiated'.
     */
    @JvmName("rxxetnouyxdhlbpf")
    public suspend fun softwareInstallationType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.softwareInstallationType = mapped
    }

    /**
     * @param value The software version to install.
     */
    @JvmName("tttwbgvhsrnfoukt")
    public suspend fun softwareVersion(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.softwareVersion = mapped
    }

    /**
     * @param value The SSH private key.
     */
    @JvmName("llbcufmycspwujwy")
    public suspend fun sshPrivateKey(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sshPrivateKey = mapped
    }

    internal fun build(): ServiceInitiatedSoftwareConfigurationArgs =
        ServiceInitiatedSoftwareConfigurationArgs(
            bomUrl = bomUrl ?: throw PulumiNullFieldException("bomUrl"),
            highAvailabilitySoftwareConfiguration = highAvailabilitySoftwareConfiguration,
            sapBitsStorageAccountId = sapBitsStorageAccountId ?: throw
                PulumiNullFieldException("sapBitsStorageAccountId"),
            sapFqdn = sapFqdn ?: throw PulumiNullFieldException("sapFqdn"),
            softwareInstallationType = softwareInstallationType ?: throw
                PulumiNullFieldException("softwareInstallationType"),
            softwareVersion = softwareVersion ?: throw PulumiNullFieldException("softwareVersion"),
            sshPrivateKey = sshPrivateKey ?: throw PulumiNullFieldException("sshPrivateKey"),
        )
}
