@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.SettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Common settings field for backup management
 * @property isCompression Workload compression flag. This has been added so that 'isSqlCompression'
 * will be deprecated once clients upgrade to consider this flag.
 * @property issqlcompression SQL compression flag
 * @property timeZone TimeZone optional input as string. For example: TimeZone = "Pacific Standard Time".
 */
public data class SettingsArgs(
    public val isCompression: Output<Boolean>? = null,
    public val issqlcompression: Output<Boolean>? = null,
    public val timeZone: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.SettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.inputs.SettingsArgs =
        com.pulumi.azurenative.workloads.inputs.SettingsArgs.builder()
            .isCompression(isCompression?.applyValue({ args0 -> args0 }))
            .issqlcompression(issqlcompression?.applyValue({ args0 -> args0 }))
            .timeZone(timeZone?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SettingsArgs].
 */
@PulumiTagMarker
public class SettingsArgsBuilder internal constructor() {
    private var isCompression: Output<Boolean>? = null

    private var issqlcompression: Output<Boolean>? = null

    private var timeZone: Output<String>? = null

    /**
     * @param value Workload compression flag. This has been added so that 'isSqlCompression'
     * will be deprecated once clients upgrade to consider this flag.
     */
    @JvmName("xnsykhrlglpaxlkl")
    public suspend fun isCompression(`value`: Output<Boolean>) {
        this.isCompression = value
    }

    /**
     * @param value SQL compression flag
     */
    @JvmName("pwxdtyfqtwuflabp")
    public suspend fun issqlcompression(`value`: Output<Boolean>) {
        this.issqlcompression = value
    }

    /**
     * @param value TimeZone optional input as string. For example: TimeZone = "Pacific Standard Time".
     */
    @JvmName("pfbpoteaygnbgmtp")
    public suspend fun timeZone(`value`: Output<String>) {
        this.timeZone = value
    }

    /**
     * @param value Workload compression flag. This has been added so that 'isSqlCompression'
     * will be deprecated once clients upgrade to consider this flag.
     */
    @JvmName("liyxylasdlfuvcku")
    public suspend fun isCompression(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isCompression = mapped
    }

    /**
     * @param value SQL compression flag
     */
    @JvmName("wpnrhuojcqwqpsau")
    public suspend fun issqlcompression(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.issqlcompression = mapped
    }

    /**
     * @param value TimeZone optional input as string. For example: TimeZone = "Pacific Standard Time".
     */
    @JvmName("ojsgjswppjlqedly")
    public suspend fun timeZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeZone = mapped
    }

    internal fun build(): SettingsArgs = SettingsArgs(
        isCompression = isCompression,
        issqlcompression = issqlcompression,
        timeZone = timeZone,
    )
}
