@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.SharedStorageResourceNamesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The resource names object for shared storage.
 * @property sharedStorageAccountName The full name of the shared storage account. If it is not provided, it will be defaulted to {SID}nfs{guid of 15 chars}.
 * @property sharedStorageAccountPrivateEndPointName The full name of private end point for the shared storage account. If it is not provided, it will be defaulted to {storageAccountName}_pe
 */
public data class SharedStorageResourceNamesArgs(
    public val sharedStorageAccountName: Output<String>? = null,
    public val sharedStorageAccountPrivateEndPointName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.SharedStorageResourceNamesArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.inputs.SharedStorageResourceNamesArgs =
        com.pulumi.azurenative.workloads.inputs.SharedStorageResourceNamesArgs.builder()
            .sharedStorageAccountName(sharedStorageAccountName?.applyValue({ args0 -> args0 }))
            .sharedStorageAccountPrivateEndPointName(
                sharedStorageAccountPrivateEndPointName?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [SharedStorageResourceNamesArgs].
 */
@PulumiTagMarker
public class SharedStorageResourceNamesArgsBuilder internal constructor() {
    private var sharedStorageAccountName: Output<String>? = null

    private var sharedStorageAccountPrivateEndPointName: Output<String>? = null

    /**
     * @param value The full name of the shared storage account. If it is not provided, it will be defaulted to {SID}nfs{guid of 15 chars}.
     */
    @JvmName("edrogelxucmhnvct")
    public suspend fun sharedStorageAccountName(`value`: Output<String>) {
        this.sharedStorageAccountName = value
    }

    /**
     * @param value The full name of private end point for the shared storage account. If it is not provided, it will be defaulted to {storageAccountName}_pe
     */
    @JvmName("gsqsvcldjmflgmhn")
    public suspend fun sharedStorageAccountPrivateEndPointName(`value`: Output<String>) {
        this.sharedStorageAccountPrivateEndPointName = value
    }

    /**
     * @param value The full name of the shared storage account. If it is not provided, it will be defaulted to {SID}nfs{guid of 15 chars}.
     */
    @JvmName("nmjptvyyeysckwwp")
    public suspend fun sharedStorageAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sharedStorageAccountName = mapped
    }

    /**
     * @param value The full name of private end point for the shared storage account. If it is not provided, it will be defaulted to {storageAccountName}_pe
     */
    @JvmName("omnqrmnrywagrxgv")
    public suspend fun sharedStorageAccountPrivateEndPointName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sharedStorageAccountPrivateEndPointName = mapped
    }

    internal fun build(): SharedStorageResourceNamesArgs = SharedStorageResourceNamesArgs(
        sharedStorageAccountName = sharedStorageAccountName,
        sharedStorageAccountPrivateEndPointName = sharedStorageAccountPrivateEndPointName,
    )
}
