@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.SkipFileShareConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Gets or sets the file share configuration for scenarios where transport directory fileshare is not created or required.
 * @property configurationType The type of file share config.
 * Expected value is 'Skip'.
 */
public data class SkipFileShareConfigurationArgs(
    public val configurationType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.SkipFileShareConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.inputs.SkipFileShareConfigurationArgs =
        com.pulumi.azurenative.workloads.inputs.SkipFileShareConfigurationArgs.builder()
            .configurationType(configurationType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SkipFileShareConfigurationArgs].
 */
@PulumiTagMarker
public class SkipFileShareConfigurationArgsBuilder internal constructor() {
    private var configurationType: Output<String>? = null

    /**
     * @param value The type of file share config.
     * Expected value is 'Skip'.
     */
    @JvmName("jiftmlnmjntlarob")
    public suspend fun configurationType(`value`: Output<String>) {
        this.configurationType = value
    }

    /**
     * @param value The type of file share config.
     * Expected value is 'Skip'.
     */
    @JvmName("aafwgaguhhhqucph")
    public suspend fun configurationType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configurationType = mapped
    }

    internal fun build(): SkipFileShareConfigurationArgs = SkipFileShareConfigurationArgs(
        configurationType = configurationType ?: throw PulumiNullFieldException("configurationType"),
    )
}
