@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.SshPublicKeyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Contains information about SSH certificate public key and the path on the Linux VM where the public key is placed.
 * @property keyData SSH public key certificate used to authenticate with the VM through ssh. The key needs to be at least 2048-bit and in ssh-rsa format. <br><br> For creating ssh keys, see [Create SSH keys on Linux and Mac for Linux VMs in Azure](https://docs.microsoft.com/azure/virtual-machines/linux/create-ssh-keys-detailed).
 */
public data class SshPublicKeyArgs(
    public val keyData: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.SshPublicKeyArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.inputs.SshPublicKeyArgs =
        com.pulumi.azurenative.workloads.inputs.SshPublicKeyArgs.builder()
            .keyData(keyData?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SshPublicKeyArgs].
 */
@PulumiTagMarker
public class SshPublicKeyArgsBuilder internal constructor() {
    private var keyData: Output<String>? = null

    /**
     * @param value SSH public key certificate used to authenticate with the VM through ssh. The key needs to be at least 2048-bit and in ssh-rsa format. <br><br> For creating ssh keys, see [Create SSH keys on Linux and Mac for Linux VMs in Azure](https://docs.microsoft.com/azure/virtual-machines/linux/create-ssh-keys-detailed).
     */
    @JvmName("kditbqpkxhwtpkaw")
    public suspend fun keyData(`value`: Output<String>) {
        this.keyData = value
    }

    /**
     * @param value SSH public key certificate used to authenticate with the VM through ssh. The key needs to be at least 2048-bit and in ssh-rsa format. <br><br> For creating ssh keys, see [Create SSH keys on Linux and Mac for Linux VMs in Azure](https://docs.microsoft.com/azure/virtual-machines/linux/create-ssh-keys-detailed).
     */
    @JvmName("kkwbppktlfbgbsrv")
    public suspend fun keyData(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyData = mapped
    }

    internal fun build(): SshPublicKeyArgs = SshPublicKeyArgs(
        keyData = keyData,
    )
}
