@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.VirtualMachineConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Defines the virtual machine configuration.
 * @property imageReference The image reference.
 * @property osProfile The OS profile.
 * @property vmSize The virtual machine size.
 */
public data class VirtualMachineConfigurationArgs(
    public val imageReference: Output<ImageReferenceArgs>,
    public val osProfile: Output<OSProfileArgs>,
    public val vmSize: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.VirtualMachineConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.inputs.VirtualMachineConfigurationArgs =
        com.pulumi.azurenative.workloads.inputs.VirtualMachineConfigurationArgs.builder()
            .imageReference(imageReference.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .osProfile(osProfile.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .vmSize(vmSize.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualMachineConfigurationArgs].
 */
@PulumiTagMarker
public class VirtualMachineConfigurationArgsBuilder internal constructor() {
    private var imageReference: Output<ImageReferenceArgs>? = null

    private var osProfile: Output<OSProfileArgs>? = null

    private var vmSize: Output<String>? = null

    /**
     * @param value The image reference.
     */
    @JvmName("emoucvipybaypfjb")
    public suspend fun imageReference(`value`: Output<ImageReferenceArgs>) {
        this.imageReference = value
    }

    /**
     * @param value The OS profile.
     */
    @JvmName("qabtfkpqgxinegaq")
    public suspend fun osProfile(`value`: Output<OSProfileArgs>) {
        this.osProfile = value
    }

    /**
     * @param value The virtual machine size.
     */
    @JvmName("foqmcbanmmmrbbih")
    public suspend fun vmSize(`value`: Output<String>) {
        this.vmSize = value
    }

    /**
     * @param value The image reference.
     */
    @JvmName("oifhisoqqjiitaqu")
    public suspend fun imageReference(`value`: ImageReferenceArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.imageReference = mapped
    }

    /**
     * @param argument The image reference.
     */
    @JvmName("abtjkjodgdlvsgty")
    public suspend fun imageReference(argument: suspend ImageReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = ImageReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.imageReference = mapped
    }

    /**
     * @param value The OS profile.
     */
    @JvmName("ixowvqqijrbvdokt")
    public suspend fun osProfile(`value`: OSProfileArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.osProfile = mapped
    }

    /**
     * @param argument The OS profile.
     */
    @JvmName("ocvxhkildbbyklmu")
    public suspend fun osProfile(argument: suspend OSProfileArgsBuilder.() -> Unit) {
        val toBeMapped = OSProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.osProfile = mapped
    }

    /**
     * @param value The virtual machine size.
     */
    @JvmName("cdxeqhahjhqbjbaa")
    public suspend fun vmSize(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vmSize = mapped
    }

    internal fun build(): VirtualMachineConfigurationArgs = VirtualMachineConfigurationArgs(
        imageReference = imageReference ?: throw PulumiNullFieldException("imageReference"),
        osProfile = osProfile ?: throw PulumiNullFieldException("osProfile"),
        vmSize = vmSize ?: throw PulumiNullFieldException("vmSize"),
    )
}
