@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The SAP Central Services Instance VM details.
 * @property storageDetails Storage details of all the Storage Accounts attached to the ASCS Virtual Machine. For e.g. NFS on AFS Shared Storage.
 * @property type Defines the type of central server VM.
 * @property virtualMachineId
 */
public data class CentralServerVmDetailsResponse(
    public val storageDetails: List<StorageInformationResponse>,
    public val type: String,
    public val virtualMachineId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.CentralServerVmDetailsResponse):
            CentralServerVmDetailsResponse = CentralServerVmDetailsResponse(
            storageDetails = javaType.storageDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.workloads.kotlin.outputs.StorageInformationResponse.Companion.toKotlin(args0)
                })
            }),
            type = javaType.type(),
            virtualMachineId = javaType.virtualMachineId(),
        )
    }
}
