@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress
import kotlin.collections.List

/**
 * Defines the disk exclusion properties for virtual machine backup.
 * @property diskLunList List of Disks' Logical Unit Numbers (LUN) to be used for VM Protection.
 * @property isInclusionList Flag to indicate whether DiskLunList is to be included/ excluded from backup.
 */
public data class DiskExclusionPropertiesResponse(
    public val diskLunList: List<Int>,
    public val isInclusionList: Boolean,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.DiskExclusionPropertiesResponse):
            DiskExclusionPropertiesResponse = DiskExclusionPropertiesResponse(
            diskLunList = javaType.diskLunList().map({ args0 -> args0 }),
            isInclusionList = javaType.isInclusionList(),
        )
    }
}
