@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * A provider instance associated with SAP monitor.
 * @property errors Defines the provider instance errors.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property identity [currently not in use] Managed service identity(user assigned identities)
 * @property name The name of the resource
 * @property providerSettings Defines the provider specific properties.
 * @property provisioningState State of provisioning of the provider instance
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetProviderInstanceResult(
    public val errors: ProviderInstancePropertiesResponseErrors,
    public val id: String,
    public val identity: UserAssignedServiceIdentityResponse? = null,
    public val name: String,
    public val providerSettings: Any? = null,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.GetProviderInstanceResult):
            GetProviderInstanceResult = GetProviderInstanceResult(
            errors = javaType.errors().let({ args0 ->
                com.pulumi.azurenative.workloads.kotlin.outputs.ProviderInstancePropertiesResponseErrors.Companion.toKotlin(args0)
            }),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.workloads.kotlin.outputs.UserAssignedServiceIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name(),
            providerSettings = javaType.providerSettings().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.workloads.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
