@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Define the SAP Application Server Instance resource.
 * @property errors Defines the Application Instance errors.
 * @property gatewayPort Application server instance gateway Port.
 * @property health Defines the health of SAP Instances.
 * @property hostname Application server instance SAP hostname.
 * @property icmHttpPort Application server instance ICM HTTP Port.
 * @property icmHttpsPort Application server instance ICM HTTPS Port.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property instanceNo Application server Instance Number.
 * @property ipAddress  Application server instance SAP IP Address.
 * @property kernelPatch Application server instance SAP Kernel Patch level.
 * @property kernelVersion  Application server instance SAP Kernel Version.
 * @property loadBalancerDetails The Load Balancer details such as LoadBalancer ID attached to Application Server Virtual Machines
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property provisioningState Defines the provisioning states.
 * @property status Defines the SAP Instance status.
 * @property subnet Application server Subnet.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property vmDetails The list of virtual machines.
 */
public data class GetSAPApplicationServerInstanceResult(
    public val errors: SAPVirtualInstanceErrorResponse,
    public val gatewayPort: Double,
    public val health: String,
    public val hostname: String,
    public val icmHttpPort: Double,
    public val icmHttpsPort: Double,
    public val id: String,
    public val instanceNo: String,
    public val ipAddress: String,
    public val kernelPatch: String,
    public val kernelVersion: String,
    public val loadBalancerDetails: LoadBalancerDetailsResponse,
    public val location: String,
    public val name: String,
    public val provisioningState: String,
    public val status: String,
    public val subnet: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val vmDetails: List<ApplicationServerVmDetailsResponse>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.GetSAPApplicationServerInstanceResult):
            GetSAPApplicationServerInstanceResult = GetSAPApplicationServerInstanceResult(
            errors = javaType.errors().let({ args0 ->
                com.pulumi.azurenative.workloads.kotlin.outputs.SAPVirtualInstanceErrorResponse.Companion.toKotlin(args0)
            }),
            gatewayPort = javaType.gatewayPort(),
            health = javaType.health(),
            hostname = javaType.hostname(),
            icmHttpPort = javaType.icmHttpPort(),
            icmHttpsPort = javaType.icmHttpsPort(),
            id = javaType.id(),
            instanceNo = javaType.instanceNo(),
            ipAddress = javaType.ipAddress(),
            kernelPatch = javaType.kernelPatch(),
            kernelVersion = javaType.kernelVersion(),
            loadBalancerDetails = javaType.loadBalancerDetails().let({ args0 ->
                com.pulumi.azurenative.workloads.kotlin.outputs.LoadBalancerDetailsResponse.Companion.toKotlin(args0)
            }),
            location = javaType.location(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            status = javaType.status(),
            subnet = javaType.subnet(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.workloads.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            vmDetails = javaType.vmDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.workloads.kotlin.outputs.ApplicationServerVmDetailsResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
