@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Define the Virtual Instance for SAP solutions resource.
 * @property configuration Defines if the SAP system is being created using Azure Center for SAP solutions (ACSS) or if an existing SAP system is being registered with ACSS
 * @property environment Defines the environment type - Production/Non Production.
 * @property errors Indicates any errors on the Virtual Instance for SAP solutions resource.
 * @property health Defines the health of SAP Instances.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property identity A pre-created user assigned identity with appropriate roles assigned. To learn more on identity and roles required, visit the ACSS how-to-guide.
 * @property location The geo-location where the resource lives
 * @property managedResourceGroupConfiguration Managed resource group configuration
 * @property name The name of the resource
 * @property provisioningState Defines the provisioning states.
 * @property sapProduct Defines the SAP Product type.
 * @property state Defines the Virtual Instance for SAP state.
 * @property status Defines the SAP Instance status.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetSAPVirtualInstanceResult(
    public val configuration: Any,
    public val environment: String,
    public val errors: SAPVirtualInstanceErrorResponse,
    public val health: String,
    public val id: String,
    public val identity: UserAssignedServiceIdentityResponse? = null,
    public val location: String,
    public val managedResourceGroupConfiguration: ManagedRGConfigurationResponse? = null,
    public val name: String,
    public val provisioningState: String,
    public val sapProduct: String,
    public val state: String,
    public val status: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.GetSAPVirtualInstanceResult):
            GetSAPVirtualInstanceResult = GetSAPVirtualInstanceResult(
            configuration = javaType.configuration(),
            environment = javaType.environment(),
            errors = javaType.errors().let({ args0 ->
                com.pulumi.azurenative.workloads.kotlin.outputs.SAPVirtualInstanceErrorResponse.Companion.toKotlin(args0)
            }),
            health = javaType.health(),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.workloads.kotlin.outputs.UserAssignedServiceIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location(),
            managedResourceGroupConfiguration = javaType.managedResourceGroupConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.workloads.kotlin.outputs.ManagedRGConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            sapProduct = javaType.sapProduct(),
            state = javaType.state(),
            status = javaType.status(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.workloads.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
