@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Gets or sets the file share configuration where the transport directory fileshare already exists, and user wishes to mount the fileshare as a part of the create infra flow.
 * @property configurationType The type of file share config.
 * Expected value is 'Mount'.
 * @property id The fileshare resource ID
 * @property privateEndpointId The private endpoint resource ID
 */
public data class MountFileShareConfigurationResponse(
    public val configurationType: String,
    public val id: String,
    public val privateEndpointId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.MountFileShareConfigurationResponse):
            MountFileShareConfigurationResponse = MountFileShareConfigurationResponse(
            configurationType = javaType.configurationType(),
            id = javaType.id(),
            privateEndpointId = javaType.privateEndpointId(),
        )
    }
}
