@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * New recovery services vault.
 * @property name The name of the recovery services vault has to be created.
 * @property resourceGroup The name of the resource group where the recovery services vault has to be created.
 * @property vaultType The vault type, whether it is existing or has to be created.
 * Expected value is 'New'.
 */
public data class NewRecoveryServicesVaultResponse(
    public val name: String,
    public val resourceGroup: String,
    public val vaultType: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.NewRecoveryServicesVaultResponse):
            NewRecoveryServicesVaultResponse = NewRecoveryServicesVaultResponse(
            name = javaType.name(),
            resourceGroup = javaType.resourceGroup(),
            vaultType = javaType.vaultType(),
        )
    }
}
