@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Gets or sets the PrometheusOS provider properties.
 * @property prometheusUrl URL of the Node Exporter endpoint
 * @property providerType The provider type. For example, the value can be SapHana.
 * Expected value is 'PrometheusOS'.
 * @property sapSid Gets or sets the SAP System Identifier
 * @property sslCertificateUri Gets or sets the blob URI to SSL certificate for the prometheus node exporter.
 * @property sslPreference Gets or sets certificate preference if secure communication is enabled.
 */
public data class PrometheusOSProviderInstancePropertiesResponse(
    public val prometheusUrl: String? = null,
    public val providerType: String,
    public val sapSid: String? = null,
    public val sslCertificateUri: String? = null,
    public val sslPreference: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.PrometheusOSProviderInstancePropertiesResponse):
            PrometheusOSProviderInstancePropertiesResponse =
            PrometheusOSProviderInstancePropertiesResponse(
                prometheusUrl = javaType.prometheusUrl().map({ args0 -> args0 }).orElse(null),
                providerType = javaType.providerType(),
                sapSid = javaType.sapSid().map({ args0 -> args0 }).orElse(null),
                sslCertificateUri = javaType.sslCertificateUri().map({ args0 -> args0 }).orElse(null),
                sslPreference = javaType.sslPreference().map({ args0 -> args0 }).orElse(null),
            )
    }
}
