@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.Double
import kotlin.Suppress

/**
 * The SAP Availability Zone Pair.
 * @property zoneA The zone A.
 * @property zoneB The zone B.
 */
public data class SAPAvailabilityZonePairResponse(
    public val zoneA: Double? = null,
    public val zoneB: Double? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.SAPAvailabilityZonePairResponse):
            SAPAvailabilityZonePairResponse = SAPAvailabilityZonePairResponse(
            zoneA = javaType.zoneA().map({ args0 -> args0 }).orElse(null),
            zoneB = javaType.zoneB().map({ args0 -> args0 }).orElse(null),
        )
    }
}
