@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Specify the HANA database TLS/SSL properties which will be used for enabling Azure Backup for this database. You need to specify these details if you have enabled secure communication for your HANA database.
 * @property sslCryptoProvider Specify the crypto provider being used (commoncrypto/openssl). If this argument is not provided, it is automatically determined by searching in the configuration files.
 * @property sslHostNameInCertificate Specify the hostname as mentioned in the SSL certificate. If this argument is not provided, it is automatically determined by searching in the SSL certificate.
 * @property sslKeyStore Specify the name of the keystore file that contains the client's identity (eg. sapsrv.pse). The script will search for the file in the appropriate directory depending on the crypto provider mentioned. If this argument is not provided, it is automatically determined by searching in the configuration files.
 * @property sslTrustStore Specify the name of the trust store file that contains the server’s public certificates (eg. sapsrv.pse). The script will search for the file in the appropriate directory depending on the crypto provider mentioned. If this argument is not provided, it is automatically determined by searching in the configuration files.
 */
public data class SSLConfigurationResponse(
    public val sslCryptoProvider: String? = null,
    public val sslHostNameInCertificate: String? = null,
    public val sslKeyStore: String? = null,
    public val sslTrustStore: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.SSLConfigurationResponse):
            SSLConfigurationResponse = SSLConfigurationResponse(
            sslCryptoProvider = javaType.sslCryptoProvider().map({ args0 -> args0 }).orElse(null),
            sslHostNameInCertificate = javaType.sslHostNameInCertificate().map({ args0 -> args0 }).orElse(null),
            sslKeyStore = javaType.sslKeyStore().map({ args0 -> args0 }).orElse(null),
            sslTrustStore = javaType.sslTrustStore().map({ args0 -> args0 }).orElse(null),
        )
    }
}
