@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Gets or sets the single server configuration. For prerequisites for creating the infrastructure, please see [here](https://go.microsoft.com/fwlink/?linkid=2212611&clcid=0x409)
 * @property appResourceGroup The application resource group where SAP system resources will be deployed.
 * @property customResourceNames The set of custom names to be used for underlying azure resources that are part of the SAP system.
 * @property databaseType The database type.
 * @property dbDiskConfiguration Gets or sets the disk configuration.
 * @property deploymentType The type of SAP deployment, single server or Three tier.
 * Expected value is 'SingleServer'.
 * @property networkConfiguration Network configuration for the server
 * @property subnetId The subnet id.
 * @property virtualMachineConfiguration Gets or sets the virtual machine configuration.
 */
public data class SingleServerConfigurationResponse(
    public val appResourceGroup: String,
    public val customResourceNames: SingleServerFullResourceNamesResponse? = null,
    public val databaseType: String? = null,
    public val dbDiskConfiguration: DiskConfigurationResponse? = null,
    public val deploymentType: String,
    public val networkConfiguration: NetworkConfigurationResponse? = null,
    public val subnetId: String,
    public val virtualMachineConfiguration: VirtualMachineConfigurationResponse,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.SingleServerConfigurationResponse):
            SingleServerConfigurationResponse = SingleServerConfigurationResponse(
            appResourceGroup = javaType.appResourceGroup(),
            customResourceNames = javaType.customResourceNames().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.workloads.kotlin.outputs.SingleServerFullResourceNamesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            databaseType = javaType.databaseType().map({ args0 -> args0 }).orElse(null),
            dbDiskConfiguration = javaType.dbDiskConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.workloads.kotlin.outputs.DiskConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            deploymentType = javaType.deploymentType(),
            networkConfiguration = javaType.networkConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.workloads.kotlin.outputs.NetworkConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            subnetId = javaType.subnetId(),
            virtualMachineConfiguration = javaType.virtualMachineConfiguration().let({ args0 ->
                com.pulumi.azurenative.workloads.kotlin.outputs.VirtualMachineConfigurationResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
