@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.Any
import kotlin.Suppress

/**
 * Gets or sets the storage configuration.
 * @property transportFileShareConfiguration The properties of the transport directory attached to the VIS. The default for transportFileShareConfiguration is the createAndMount flow if storage configuration is missing.
 */
public data class StorageConfigurationResponse(
    public val transportFileShareConfiguration: Any? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.StorageConfigurationResponse):
            StorageConfigurationResponse = StorageConfigurationResponse(
            transportFileShareConfiguration = javaType.transportFileShareConfiguration().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
