@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Weekly retention schedule.
 * @property daysOfTheWeek List of days of week for weekly retention policy.
 * @property retentionDuration Retention duration of retention Policy.
 * @property retentionTimes Retention times of retention policy.
 */
public data class WeeklyRetentionScheduleResponse(
    public val daysOfTheWeek: List<String>? = null,
    public val retentionDuration: RetentionDurationResponse? = null,
    public val retentionTimes: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.WeeklyRetentionScheduleResponse):
            WeeklyRetentionScheduleResponse = WeeklyRetentionScheduleResponse(
            daysOfTheWeek = javaType.daysOfTheWeek().map({ args0 -> args0 }),
            retentionDuration = javaType.retentionDuration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.workloads.kotlin.outputs.RetentionDurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            retentionTimes = javaType.retentionTimes().map({ args0 -> args0 }),
        )
    }
}
