@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.aad.kotlin

import com.pulumi.azurenative.aad.AadFunctions.getDomainServicePlain
import com.pulumi.azurenative.aad.AadFunctions.getOuContainerPlain
import com.pulumi.azurenative.aad.kotlin.inputs.GetDomainServicePlainArgs
import com.pulumi.azurenative.aad.kotlin.inputs.GetDomainServicePlainArgsBuilder
import com.pulumi.azurenative.aad.kotlin.inputs.GetOuContainerPlainArgs
import com.pulumi.azurenative.aad.kotlin.inputs.GetOuContainerPlainArgsBuilder
import com.pulumi.azurenative.aad.kotlin.outputs.GetDomainServiceResult
import com.pulumi.azurenative.aad.kotlin.outputs.GetOuContainerResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.aad.kotlin.outputs.GetDomainServiceResult.Companion.toKotlin as getDomainServiceResultToKotlin
import com.pulumi.azurenative.aad.kotlin.outputs.GetOuContainerResult.Companion.toKotlin as getOuContainerResultToKotlin

public object AadFunctions {
    /**
     * The Get Domain Service operation retrieves a json representation of the Domain Service.
     * Azure REST API version: 2022-12-01.
     * Other available API versions: 2017-06-01.
     * @param argument null
     * @return Domain service.
     */
    public suspend fun getDomainService(argument: GetDomainServicePlainArgs): GetDomainServiceResult =
        getDomainServiceResultToKotlin(getDomainServicePlain(argument.toJava()).await())

    /**
     * @see [getDomainService].
     * @param domainServiceName The name of the domain service.
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
     * @return Domain service.
     */
    public suspend fun getDomainService(domainServiceName: String, resourceGroupName: String):
        GetDomainServiceResult {
        val argument = GetDomainServicePlainArgs(
            domainServiceName = domainServiceName,
            resourceGroupName = resourceGroupName,
        )
        return getDomainServiceResultToKotlin(getDomainServicePlain(argument.toJava()).await())
    }

    /**
     * @see [getDomainService].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;aad&#46;kotlin&#46;inputs&#46;GetDomainServicePlainArgs].
     * @return Domain service.
     */
    public suspend
    fun getDomainService(argument: suspend GetDomainServicePlainArgsBuilder.() -> Unit):
        GetDomainServiceResult {
        val builder = GetDomainServicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDomainServiceResultToKotlin(getDomainServicePlain(builtArgument.toJava()).await())
    }

    /**
     * Get OuContainer in DomainService instance.
     * Azure REST API version: 2022-12-01.
     * @param argument null
     * @return Resource for OuContainer.
     */
    public suspend fun getOuContainer(argument: GetOuContainerPlainArgs): GetOuContainerResult =
        getOuContainerResultToKotlin(getOuContainerPlain(argument.toJava()).await())

    /**
     * @see [getOuContainer].
     * @param domainServiceName The name of the domain service.
     * @param ouContainerName The name of the OuContainer.
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
     * @return Resource for OuContainer.
     */
    public suspend fun getOuContainer(
        domainServiceName: String,
        ouContainerName: String,
        resourceGroupName: String,
    ): GetOuContainerResult {
        val argument = GetOuContainerPlainArgs(
            domainServiceName = domainServiceName,
            ouContainerName = ouContainerName,
            resourceGroupName = resourceGroupName,
        )
        return getOuContainerResultToKotlin(getOuContainerPlain(argument.toJava()).await())
    }

    /**
     * @see [getOuContainer].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;aad&#46;kotlin&#46;inputs&#46;GetOuContainerPlainArgs].
     * @return Resource for OuContainer.
     */
    public suspend fun getOuContainer(argument: suspend GetOuContainerPlainArgsBuilder.() -> Unit):
        GetOuContainerResult {
        val builder = GetOuContainerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getOuContainerResultToKotlin(getOuContainerPlain(builtArgument.toJava()).await())
    }
}
