@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.aad.kotlin

import com.pulumi.azurenative.aad.OuContainerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Resource for OuContainer.
 * Azure REST API version: 2022-12-01. Prior API version in Azure Native 1.x: 2021-03-01.
 * ## Example Usage
 * ### Create Domain Service
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var ouContainer = new AzureNative.Aad.OuContainer("ouContainer", new()
 *     {
 *         AccountName = "AccountName1",
 *         DomainServiceName = "OuContainer.com",
 *         OuContainerName = "OuContainer1",
 *         Password = "<password>",
 *         ResourceGroupName = "OuContainerResourceGroup",
 *         Spn = "Spn1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/aad/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := aad.NewOuContainer(ctx, "ouContainer", &aad.OuContainerArgs{
 * 			AccountName:       pulumi.String("AccountName1"),
 * 			DomainServiceName: pulumi.String("OuContainer.com"),
 * 			OuContainerName:   pulumi.String("OuContainer1"),
 * 			Password:          pulumi.String("<password>"),
 * 			ResourceGroupName: pulumi.String("OuContainerResourceGroup"),
 * 			Spn:               pulumi.String("Spn1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.aad.OuContainer;
 * import com.pulumi.azurenative.aad.OuContainerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var ouContainer = new OuContainer("ouContainer", OuContainerArgs.builder()
 *             .accountName("AccountName1")
 *             .domainServiceName("OuContainer.com")
 *             .ouContainerName("OuContainer1")
 *             .password("<password>")
 *             .resourceGroupName("OuContainerResourceGroup")
 *             .spn("Spn1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:aad:OuContainer OuContainer.com/OuContainer1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Aad/domainServices/{domainServiceName}/ouContainer/{ouContainerName}
 * ```
 * @property accountName The account name
 * @property domainServiceName The name of the domain service.
 * @property ouContainerName The name of the OuContainer.
 * @property password The account password
 * @property resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
 * @property spn The account spn
 */
public data class OuContainerArgs(
    public val accountName: Output<String>? = null,
    public val domainServiceName: Output<String>? = null,
    public val ouContainerName: Output<String>? = null,
    public val password: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val spn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.aad.OuContainerArgs> {
    override fun toJava(): com.pulumi.azurenative.aad.OuContainerArgs =
        com.pulumi.azurenative.aad.OuContainerArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .domainServiceName(domainServiceName?.applyValue({ args0 -> args0 }))
            .ouContainerName(ouContainerName?.applyValue({ args0 -> args0 }))
            .password(password?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .spn(spn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OuContainerArgs].
 */
@PulumiTagMarker
public class OuContainerArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var domainServiceName: Output<String>? = null

    private var ouContainerName: Output<String>? = null

    private var password: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var spn: Output<String>? = null

    /**
     * @param value The account name
     */
    @JvmName("rbxjpybgrtcegpsi")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value The name of the domain service.
     */
    @JvmName("bxwdvjklofrxwhvd")
    public suspend fun domainServiceName(`value`: Output<String>) {
        this.domainServiceName = value
    }

    /**
     * @param value The name of the OuContainer.
     */
    @JvmName("febnalsebjkruhcb")
    public suspend fun ouContainerName(`value`: Output<String>) {
        this.ouContainerName = value
    }

    /**
     * @param value The account password
     */
    @JvmName("sqoqrjlbmqeuhiis")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("lyqwipghftdytusr")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The account spn
     */
    @JvmName("kqotvrrcitxajpxx")
    public suspend fun spn(`value`: Output<String>) {
        this.spn = value
    }

    /**
     * @param value The account name
     */
    @JvmName("prpwveuppctxubce")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value The name of the domain service.
     */
    @JvmName("rmtvxtsysqiyighw")
    public suspend fun domainServiceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainServiceName = mapped
    }

    /**
     * @param value The name of the OuContainer.
     */
    @JvmName("pgouttmvveqqtmiw")
    public suspend fun ouContainerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ouContainerName = mapped
    }

    /**
     * @param value The account password
     */
    @JvmName("jeqhugqxoofdptqs")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("oefldabeqgvljyyn")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The account spn
     */
    @JvmName("xribicbgvosmmakn")
    public suspend fun spn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spn = mapped
    }

    internal fun build(): OuContainerArgs = OuContainerArgs(
        accountName = accountName,
        domainServiceName = domainServiceName,
        ouContainerName = ouContainerName,
        password = password,
        resourceGroupName = resourceGroupName,
        spn = spn,
    )
}
