@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.aad.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * A flag to determine whether or not ChannelBinding is enabled or disabled.
 */
public enum class ChannelBinding(
    public val javaValue: com.pulumi.azurenative.aad.enums.ChannelBinding,
) : ConvertibleToJava<com.pulumi.azurenative.aad.enums.ChannelBinding> {
    Enabled(com.pulumi.azurenative.aad.enums.ChannelBinding.Enabled),
    Disabled(com.pulumi.azurenative.aad.enums.ChannelBinding.Disabled),
    ;

    override fun toJava(): com.pulumi.azurenative.aad.enums.ChannelBinding = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.aad.enums.ChannelBinding): ChannelBinding =
            ChannelBinding.values().first { it.javaValue == javaType }
    }
}
