@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.aad.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * A flag to determine whether or not Secure LDAP access over the internet is enabled or disabled.
 */
public enum class ExternalAccess(
    public val javaValue: com.pulumi.azurenative.aad.enums.ExternalAccess,
) : ConvertibleToJava<com.pulumi.azurenative.aad.enums.ExternalAccess> {
    Enabled(com.pulumi.azurenative.aad.enums.ExternalAccess.Enabled),
    Disabled(com.pulumi.azurenative.aad.enums.ExternalAccess.Disabled),
    ;

    override fun toJava(): com.pulumi.azurenative.aad.enums.ExternalAccess = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.aad.enums.ExternalAccess): ExternalAccess =
            ExternalAccess.values().first { it.javaValue == javaType }
    }
}
