@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.aad.kotlin.inputs

import com.pulumi.azurenative.aad.inputs.ConfigDiagnosticsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Configuration Diagnostics
 * @property lastExecuted Last domain configuration diagnostics DateTime
 * @property validatorResults List of Configuration Diagnostics validator results.
 */
public data class ConfigDiagnosticsArgs(
    public val lastExecuted: Output<String>? = null,
    public val validatorResults: Output<List<ConfigDiagnosticsValidatorResultArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.aad.inputs.ConfigDiagnosticsArgs> {
    override fun toJava(): com.pulumi.azurenative.aad.inputs.ConfigDiagnosticsArgs =
        com.pulumi.azurenative.aad.inputs.ConfigDiagnosticsArgs.builder()
            .lastExecuted(lastExecuted?.applyValue({ args0 -> args0 }))
            .validatorResults(
                validatorResults?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ConfigDiagnosticsArgs].
 */
@PulumiTagMarker
public class ConfigDiagnosticsArgsBuilder internal constructor() {
    private var lastExecuted: Output<String>? = null

    private var validatorResults: Output<List<ConfigDiagnosticsValidatorResultArgs>>? = null

    /**
     * @param value Last domain configuration diagnostics DateTime
     */
    @JvmName("fdujbraoesbhjuox")
    public suspend fun lastExecuted(`value`: Output<String>) {
        this.lastExecuted = value
    }

    /**
     * @param value List of Configuration Diagnostics validator results.
     */
    @JvmName("jvtltktxafqpyobd")
    public suspend fun validatorResults(`value`: Output<List<ConfigDiagnosticsValidatorResultArgs>>) {
        this.validatorResults = value
    }

    @JvmName("ycwqthyimmqqlhwx")
    public suspend fun validatorResults(vararg values: Output<ConfigDiagnosticsValidatorResultArgs>) {
        this.validatorResults = Output.all(values.asList())
    }

    /**
     * @param values List of Configuration Diagnostics validator results.
     */
    @JvmName("hsyewlghlokifmfc")
    public suspend fun validatorResults(values: List<Output<ConfigDiagnosticsValidatorResultArgs>>) {
        this.validatorResults = Output.all(values)
    }

    /**
     * @param value Last domain configuration diagnostics DateTime
     */
    @JvmName("olcaticmdyjwxyvx")
    public suspend fun lastExecuted(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastExecuted = mapped
    }

    /**
     * @param value List of Configuration Diagnostics validator results.
     */
    @JvmName("krmsgocywuifjinn")
    public suspend fun validatorResults(`value`: List<ConfigDiagnosticsValidatorResultArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validatorResults = mapped
    }

    /**
     * @param argument List of Configuration Diagnostics validator results.
     */
    @JvmName("tipunfeochdfebpd")
    public suspend
    fun validatorResults(argument: List<suspend ConfigDiagnosticsValidatorResultArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ConfigDiagnosticsValidatorResultArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.validatorResults = mapped
    }

    /**
     * @param argument List of Configuration Diagnostics validator results.
     */
    @JvmName("ffsicbtnyinjrope")
    public suspend fun validatorResults(
        vararg
        argument: suspend ConfigDiagnosticsValidatorResultArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ConfigDiagnosticsValidatorResultArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.validatorResults = mapped
    }

    /**
     * @param argument List of Configuration Diagnostics validator results.
     */
    @JvmName("jhiwgdynaliqrtns")
    public suspend
    fun validatorResults(argument: suspend ConfigDiagnosticsValidatorResultArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ConfigDiagnosticsValidatorResultArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.validatorResults = mapped
    }

    /**
     * @param values List of Configuration Diagnostics validator results.
     */
    @JvmName("flslbwjrmctbgdyb")
    public suspend fun validatorResults(vararg values: ConfigDiagnosticsValidatorResultArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.validatorResults = mapped
    }

    internal fun build(): ConfigDiagnosticsArgs = ConfigDiagnosticsArgs(
        lastExecuted = lastExecuted,
        validatorResults = validatorResults,
    )
}
