@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.aad.kotlin.inputs

import com.pulumi.azurenative.aad.inputs.GetDomainServicePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property domainServiceName The name of the domain service.
 * @property resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
 */
public data class GetDomainServicePlainArgs(
    public val domainServiceName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.aad.inputs.GetDomainServicePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.aad.inputs.GetDomainServicePlainArgs =
        com.pulumi.azurenative.aad.inputs.GetDomainServicePlainArgs.builder()
            .domainServiceName(domainServiceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDomainServicePlainArgs].
 */
@PulumiTagMarker
public class GetDomainServicePlainArgsBuilder internal constructor() {
    private var domainServiceName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the domain service.
     */
    @JvmName("hsqbgkwohngorepy")
    public suspend fun domainServiceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.domainServiceName = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("stqulastrdcwguky")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetDomainServicePlainArgs = GetDomainServicePlainArgs(
        domainServiceName = domainServiceName ?: throw PulumiNullFieldException("domainServiceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
