@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.aad.kotlin.inputs

import com.pulumi.azurenative.aad.inputs.GetOuContainerPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property domainServiceName The name of the domain service.
 * @property ouContainerName The name of the OuContainer.
 * @property resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
 */
public data class GetOuContainerPlainArgs(
    public val domainServiceName: String,
    public val ouContainerName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.aad.inputs.GetOuContainerPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.aad.inputs.GetOuContainerPlainArgs =
        com.pulumi.azurenative.aad.inputs.GetOuContainerPlainArgs.builder()
            .domainServiceName(domainServiceName.let({ args0 -> args0 }))
            .ouContainerName(ouContainerName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetOuContainerPlainArgs].
 */
@PulumiTagMarker
public class GetOuContainerPlainArgsBuilder internal constructor() {
    private var domainServiceName: String? = null

    private var ouContainerName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the domain service.
     */
    @JvmName("viojndfjfvbemtjk")
    public suspend fun domainServiceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.domainServiceName = mapped
    }

    /**
     * @param value The name of the OuContainer.
     */
    @JvmName("hwfhbjqufpyvqvvy")
    public suspend fun ouContainerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ouContainerName = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("iuvvethmumthujdt")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetOuContainerPlainArgs = GetOuContainerPlainArgs(
        domainServiceName = domainServiceName ?: throw PulumiNullFieldException("domainServiceName"),
        ouContainerName = ouContainerName ?: throw PulumiNullFieldException("ouContainerName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
