@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.aad.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Migration Properties
 * @property migrationProgress Migration Progress
 * @property oldSubnetId Old Subnet Id
 * @property oldVnetSiteId Old Vnet Site Id
 */
public data class MigrationPropertiesResponse(
    public val migrationProgress: MigrationProgressResponse,
    public val oldSubnetId: String,
    public val oldVnetSiteId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.aad.outputs.MigrationPropertiesResponse):
            MigrationPropertiesResponse = MigrationPropertiesResponse(
            migrationProgress = javaType.migrationProgress().let({ args0 ->
                com.pulumi.azurenative.aad.kotlin.outputs.MigrationProgressResponse.Companion.toKotlin(args0)
            }),
            oldSubnetId = javaType.oldSubnetId(),
            oldVnetSiteId = javaType.oldVnetSiteId(),
        )
    }
}
