@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.aadiam.kotlin

import com.pulumi.azurenative.aadiam.AadiamFunctions.getAzureADMetricPlain
import com.pulumi.azurenative.aadiam.AadiamFunctions.getDiagnosticSettingPlain
import com.pulumi.azurenative.aadiam.AadiamFunctions.getPrivateEndpointConnectionPlain
import com.pulumi.azurenative.aadiam.AadiamFunctions.getPrivateLinkForAzureAdPlain
import com.pulumi.azurenative.aadiam.kotlin.inputs.GetAzureADMetricPlainArgs
import com.pulumi.azurenative.aadiam.kotlin.inputs.GetAzureADMetricPlainArgsBuilder
import com.pulumi.azurenative.aadiam.kotlin.inputs.GetDiagnosticSettingPlainArgs
import com.pulumi.azurenative.aadiam.kotlin.inputs.GetDiagnosticSettingPlainArgsBuilder
import com.pulumi.azurenative.aadiam.kotlin.inputs.GetPrivateEndpointConnectionPlainArgs
import com.pulumi.azurenative.aadiam.kotlin.inputs.GetPrivateEndpointConnectionPlainArgsBuilder
import com.pulumi.azurenative.aadiam.kotlin.inputs.GetPrivateLinkForAzureAdPlainArgs
import com.pulumi.azurenative.aadiam.kotlin.inputs.GetPrivateLinkForAzureAdPlainArgsBuilder
import com.pulumi.azurenative.aadiam.kotlin.outputs.GetAzureADMetricResult
import com.pulumi.azurenative.aadiam.kotlin.outputs.GetDiagnosticSettingResult
import com.pulumi.azurenative.aadiam.kotlin.outputs.GetPrivateEndpointConnectionResult
import com.pulumi.azurenative.aadiam.kotlin.outputs.GetPrivateLinkForAzureAdResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.aadiam.kotlin.outputs.GetAzureADMetricResult.Companion.toKotlin as getAzureADMetricResultToKotlin
import com.pulumi.azurenative.aadiam.kotlin.outputs.GetDiagnosticSettingResult.Companion.toKotlin as getDiagnosticSettingResultToKotlin
import com.pulumi.azurenative.aadiam.kotlin.outputs.GetPrivateEndpointConnectionResult.Companion.toKotlin as getPrivateEndpointConnectionResultToKotlin
import com.pulumi.azurenative.aadiam.kotlin.outputs.GetPrivateLinkForAzureAdResult.Companion.toKotlin as getPrivateLinkForAzureAdResultToKotlin

public object AadiamFunctions {
    /**
     * Gets a azureADMetrics instance with a given name.
     * Azure REST API version: 2020-07-01-preview.
     * @param argument null
     * @return AzureADMetrics resource.
     */
    public suspend fun getAzureADMetric(argument: GetAzureADMetricPlainArgs): GetAzureADMetricResult =
        getAzureADMetricResultToKotlin(getAzureADMetricPlain(argument.toJava()).await())

    /**
     * @see [getAzureADMetric].
     * @param azureADMetricsName Name of the azureADMetrics instance.
     * @param resourceGroupName Name of an Azure resource group.
     * @return AzureADMetrics resource.
     */
    public suspend fun getAzureADMetric(azureADMetricsName: String, resourceGroupName: String):
        GetAzureADMetricResult {
        val argument = GetAzureADMetricPlainArgs(
            azureADMetricsName = azureADMetricsName,
            resourceGroupName = resourceGroupName,
        )
        return getAzureADMetricResultToKotlin(getAzureADMetricPlain(argument.toJava()).await())
    }

    /**
     * @see [getAzureADMetric].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;aadiam&#46;kotlin&#46;inputs&#46;GetAzureADMetricPlainArgs].
     * @return AzureADMetrics resource.
     */
    public suspend
    fun getAzureADMetric(argument: suspend GetAzureADMetricPlainArgsBuilder.() -> Unit):
        GetAzureADMetricResult {
        val builder = GetAzureADMetricPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAzureADMetricResultToKotlin(getAzureADMetricPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the active diagnostic setting for AadIam.
     * Azure REST API version: 2017-04-01.
     * Other available API versions: 2017-04-01-preview.
     * @param argument null
     * @return The diagnostic setting resource.
     */
    public suspend fun getDiagnosticSetting(argument: GetDiagnosticSettingPlainArgs):
        GetDiagnosticSettingResult =
        getDiagnosticSettingResultToKotlin(getDiagnosticSettingPlain(argument.toJava()).await())

    /**
     * @see [getDiagnosticSetting].
     * @param name The name of the diagnostic setting.
     * @return The diagnostic setting resource.
     */
    public suspend fun getDiagnosticSetting(name: String): GetDiagnosticSettingResult {
        val argument = GetDiagnosticSettingPlainArgs(
            name = name,
        )
        return getDiagnosticSettingResultToKotlin(getDiagnosticSettingPlain(argument.toJava()).await())
    }

    /**
     * @see [getDiagnosticSetting].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;aadiam&#46;kotlin&#46;inputs&#46;GetDiagnosticSettingPlainArgs].
     * @return The diagnostic setting resource.
     */
    public suspend
    fun getDiagnosticSetting(argument: suspend GetDiagnosticSettingPlainArgsBuilder.() -> Unit):
        GetDiagnosticSettingResult {
        val builder = GetDiagnosticSettingPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDiagnosticSettingResultToKotlin(getDiagnosticSettingPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the specified private endpoint connection associated with the given policy.
     * Azure REST API version: 2020-03-01.
     * @param argument null
     * @return Private endpoint connection resource.
     */
    public suspend fun getPrivateEndpointConnection(argument: GetPrivateEndpointConnectionPlainArgs):
        GetPrivateEndpointConnectionResult =
        getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())

    /**
     * @see [getPrivateEndpointConnection].
     * @param policyName The name of the private link policy in Azure AD.
     * @param privateEndpointConnectionName The PrivateEndpointConnection name.
     * @param resourceGroupName Name of an Azure resource group.
     * @return Private endpoint connection resource.
     */
    public suspend fun getPrivateEndpointConnection(
        policyName: String,
        privateEndpointConnectionName: String,
        resourceGroupName: String,
    ): GetPrivateEndpointConnectionResult {
        val argument = GetPrivateEndpointConnectionPlainArgs(
            policyName = policyName,
            privateEndpointConnectionName = privateEndpointConnectionName,
            resourceGroupName = resourceGroupName,
        )
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateEndpointConnection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;aadiam&#46;kotlin&#46;inputs&#46;GetPrivateEndpointConnectionPlainArgs].
     * @return Private endpoint connection resource.
     */
    public suspend
    fun getPrivateEndpointConnection(argument: suspend GetPrivateEndpointConnectionPlainArgsBuilder.() -> Unit):
        GetPrivateEndpointConnectionResult {
        val builder = GetPrivateEndpointConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a private link policy with a given name.
     * Azure REST API version: 2020-03-01.
     * @param argument null
     * @return PrivateLink Policy configuration object.
     */
    public suspend fun getPrivateLinkForAzureAd(argument: GetPrivateLinkForAzureAdPlainArgs):
        GetPrivateLinkForAzureAdResult =
        getPrivateLinkForAzureAdResultToKotlin(getPrivateLinkForAzureAdPlain(argument.toJava()).await())

    /**
     * @see [getPrivateLinkForAzureAd].
     * @param policyName The name of the private link policy in Azure AD.
     * @param resourceGroupName Name of an Azure resource group.
     * @return PrivateLink Policy configuration object.
     */
    public suspend fun getPrivateLinkForAzureAd(policyName: String, resourceGroupName: String):
        GetPrivateLinkForAzureAdResult {
        val argument = GetPrivateLinkForAzureAdPlainArgs(
            policyName = policyName,
            resourceGroupName = resourceGroupName,
        )
        return getPrivateLinkForAzureAdResultToKotlin(getPrivateLinkForAzureAdPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateLinkForAzureAd].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;aadiam&#46;kotlin&#46;inputs&#46;GetPrivateLinkForAzureAdPlainArgs].
     * @return PrivateLink Policy configuration object.
     */
    public suspend
    fun getPrivateLinkForAzureAd(argument: suspend GetPrivateLinkForAzureAdPlainArgsBuilder.() -> Unit):
        GetPrivateLinkForAzureAdResult {
        val builder = GetPrivateLinkForAzureAdPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateLinkForAzureAdResultToKotlin(getPrivateLinkForAzureAdPlain(builtArgument.toJava()).await())
    }
}
