@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.aadiam.kotlin

import com.pulumi.azurenative.aadiam.kotlin.outputs.PrivateEndpointResponse
import com.pulumi.azurenative.aadiam.kotlin.outputs.PrivateLinkServiceConnectionStateResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.aadiam.kotlin.outputs.PrivateEndpointResponse.Companion.toKotlin as privateEndpointResponseToKotlin
import com.pulumi.azurenative.aadiam.kotlin.outputs.PrivateLinkServiceConnectionStateResponse.Companion.toKotlin as privateLinkServiceConnectionStateResponseToKotlin

/**
 * Builder for [PrivateEndpointConnection].
 */
@PulumiTagMarker
public class PrivateEndpointConnectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PrivateEndpointConnectionArgs = PrivateEndpointConnectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PrivateEndpointConnectionArgsBuilder.() -> Unit) {
        val builder = PrivateEndpointConnectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): PrivateEndpointConnection {
        val builtJavaResource =
            com.pulumi.azurenative.aadiam.PrivateEndpointConnection(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return PrivateEndpointConnection(builtJavaResource)
    }
}

/**
 * Private endpoint connection resource.
 * Azure REST API version: 2020-03-01. Prior API version in Azure Native 1.x: 2020-03-01.
 * ## Example Usage
 * ### AadiamPutPrivateEndpointConnection
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateEndpointConnection = new AzureNative.AadIam.PrivateEndpointConnection("privateEndpointConnection", new()
 *     {
 *         PolicyName = "example-policy-5849",
 *         PrivateEndpoint = new AzureNative.AadIam.Inputs.PrivateEndpointArgs
 *         {
 *             Id = "subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default/providers/microsoft.aadiam/privateLinkForAzureAD/ddb1/privateLinkConnections/{privateEndpointConnection name}",
 *         },
 *         PrivateEndpointConnectionName = "{privateEndpointConnection name}",
 *         PrivateLinkServiceConnectionState = new AzureNative.AadIam.Inputs.PrivateLinkServiceConnectionStateArgs
 *         {
 *             ActionsRequired = "None",
 *             Description = "You may pass",
 *             Status = "Approved",
 *         },
 *         ResourceGroupName = "resourcegroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/aadiam/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := aadiam.NewPrivateEndpointConnection(ctx, "privateEndpointConnection", &aadiam.PrivateEndpointConnectionArgs{
 * 			PolicyName: pulumi.String("example-policy-5849"),
 * 			PrivateEndpoint: &aadiam.PrivateEndpointArgs{
 * 				Id: pulumi.String("subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default/providers/microsoft.aadiam/privateLinkForAzureAD/ddb1/privateLinkConnections/{privateEndpointConnection name}"),
 * 			},
 * 			PrivateEndpointConnectionName: pulumi.String("{privateEndpointConnection name}"),
 * 			PrivateLinkServiceConnectionState: &aadiam.PrivateLinkServiceConnectionStateArgs{
 * 				ActionsRequired: pulumi.String("None"),
 * 				Description:     pulumi.String("You may pass"),
 * 				Status:          pulumi.String("Approved"),
 * 			},
 * 			ResourceGroupName: pulumi.String("resourcegroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.aadiam.PrivateEndpointConnection;
 * import com.pulumi.azurenative.aadiam.PrivateEndpointConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateEndpointConnection = new PrivateEndpointConnection("privateEndpointConnection", PrivateEndpointConnectionArgs.builder()
 *             .policyName("example-policy-5849")
 *             .privateEndpoint(Map.of("id", "subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default/providers/microsoft.aadiam/privateLinkForAzureAD/ddb1/privateLinkConnections/{privateEndpointConnection name}"))
 *             .privateEndpointConnectionName("{privateEndpointConnection name}")
 *             .privateLinkServiceConnectionState(Map.ofEntries(
 *                 Map.entry("actionsRequired", "None"),
 *                 Map.entry("description", "You may pass"),
 *                 Map.entry("status", "Approved")
 *             ))
 *             .resourceGroupName("resourcegroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:aadiam:PrivateEndpointConnection {privateEndpointConnection name} /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.aadiam/privateLinkForAzureAd/{policyName}/privateEndpointConnections/{privateEndpointConnectionName}
 * ```
 */
public class PrivateEndpointConnection internal constructor(
    override val javaResource: com.pulumi.azurenative.aadiam.PrivateEndpointConnection,
) : KotlinCustomResource(javaResource, PrivateEndpointConnectionMapper) {
    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Properties of the private endpoint object.
     */
    public val privateEndpoint: Output<PrivateEndpointResponse>?
        get() = javaResource.privateEndpoint().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> privateEndpointResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Approval state of the private link connection.
     */
    public val privateLinkServiceConnectionState: Output<PrivateLinkServiceConnectionStateResponse>?
        get() = javaResource.privateLinkServiceConnectionState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    privateLinkServiceConnectionStateResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Provisioning state of the private endpoint connection.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object PrivateEndpointConnectionMapper : ResourceMapper<PrivateEndpointConnection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.aadiam.PrivateEndpointConnection::class == javaResource::class

    override fun map(javaResource: Resource): PrivateEndpointConnection =
        PrivateEndpointConnection(
            javaResource as
                com.pulumi.azurenative.aadiam.PrivateEndpointConnection,
        )
}

/**
 * @see [PrivateEndpointConnection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PrivateEndpointConnection].
 */
public suspend fun privateEndpointConnection(
    name: String,
    block: suspend PrivateEndpointConnectionResourceBuilder.() -> Unit,
): PrivateEndpointConnection {
    val builder = PrivateEndpointConnectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PrivateEndpointConnection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun privateEndpointConnection(name: String): PrivateEndpointConnection {
    val builder = PrivateEndpointConnectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
