@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.aadiam.kotlin.inputs

import com.pulumi.azurenative.aadiam.inputs.GetDiagnosticSettingPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name The name of the diagnostic setting.
 */
public data class GetDiagnosticSettingPlainArgs(
    public val name: String,
) : ConvertibleToJava<com.pulumi.azurenative.aadiam.inputs.GetDiagnosticSettingPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.aadiam.inputs.GetDiagnosticSettingPlainArgs =
        com.pulumi.azurenative.aadiam.inputs.GetDiagnosticSettingPlainArgs.builder()
            .name(name.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDiagnosticSettingPlainArgs].
 */
@PulumiTagMarker
public class GetDiagnosticSettingPlainArgsBuilder internal constructor() {
    private var name: String? = null

    /**
     * @param value The name of the diagnostic setting.
     */
    @JvmName("sfdagegmsvsddvsy")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    internal fun build(): GetDiagnosticSettingPlainArgs = GetDiagnosticSettingPlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
