@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.aadiam.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * AzureADMetrics resource.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property properties
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetAzureADMetricResult(
    public val id: String,
    public val location: String,
    public val name: String,
    public val properties: AzureADMetricsPropertiesFormatResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.aadiam.outputs.GetAzureADMetricResult):
            GetAzureADMetricResult = GetAzureADMetricResult(
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.aadiam.kotlin.outputs.AzureADMetricsPropertiesFormatResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
