@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.advisor.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The details of the snoozed or dismissed rule; for example, the duration, name, and GUID associated with the rule.
 * @property expirationTimeStamp Gets or sets the expiration time stamp.
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property name The name of the resource
 * @property suppressionId The GUID of the suppression.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property ttl The duration for which the suppression is valid.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetSuppressionResult(
    public val expirationTimeStamp: String,
    public val id: String,
    public val name: String,
    public val suppressionId: String? = null,
    public val systemData: SystemDataResponse,
    public val ttl: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.advisor.outputs.GetSuppressionResult):
            GetSuppressionResult = GetSuppressionResult(
            expirationTimeStamp = javaType.expirationTimeStamp(),
            id = javaType.id(),
            name = javaType.name(),
            suppressionId = javaType.suppressionId().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.advisor.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            ttl = javaType.ttl().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
