@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.agfoodplatform.kotlin

import com.pulumi.azurenative.agfoodplatform.kotlin.outputs.SolutionPropertiesResponse
import com.pulumi.azurenative.agfoodplatform.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.agfoodplatform.kotlin.outputs.SolutionPropertiesResponse.Companion.toKotlin as solutionPropertiesResponseToKotlin
import com.pulumi.azurenative.agfoodplatform.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Solution].
 */
@PulumiTagMarker
public class SolutionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SolutionArgs = SolutionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SolutionArgsBuilder.() -> Unit) {
        val builder = SolutionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Solution {
        val builtJavaResource = com.pulumi.azurenative.agfoodplatform.Solution(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Solution(builtJavaResource)
    }
}

/**
 * Solution resource.
 * Azure REST API version: 2023-06-01-preview.
 * Other available API versions: 2021-09-01-preview.
 * ## Example Usage
 * ### Solutions_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var solution = new AzureNative.AgFoodPlatform.Solution("solution", new()
 *     {
 *         DataManagerForAgricultureResourceName = "examples-farmbeatsResourceName",
 *         ResourceGroupName = "examples-rg",
 *         SolutionId = "abc.partner",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/agfoodplatform/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := agfoodplatform.NewSolution(ctx, "solution", &agfoodplatform.SolutionArgs{
 * 			DataManagerForAgricultureResourceName: pulumi.String("examples-farmbeatsResourceName"),
 * 			ResourceGroupName:                     pulumi.String("examples-rg"),
 * 			SolutionId:                            pulumi.String("abc.partner"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.agfoodplatform.Solution;
 * import com.pulumi.azurenative.agfoodplatform.SolutionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var solution = new Solution("solution", SolutionArgs.builder()
 *             .dataManagerForAgricultureResourceName("examples-farmbeatsResourceName")
 *             .resourceGroupName("examples-rg")
 *             .solutionId("abc.partner")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:agfoodplatform:Solution string /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AgFoodPlatform/farmBeats/{dataManagerForAgricultureResourceName}/solutions/{solutionId}
 * ```
 */
public class Solution internal constructor(
    override val javaResource: com.pulumi.azurenative.agfoodplatform.Solution,
) : KotlinCustomResource(javaResource, SolutionMapper) {
    /**
     * The ETag value to implement optimistic concurrency.
     */
    public val eTag: Output<String>
        get() = javaResource.eTag().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Solution resource properties.
     */
    public val properties: Output<SolutionPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                solutionPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object SolutionMapper : ResourceMapper<Solution> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.agfoodplatform.Solution::class == javaResource::class

    override fun map(javaResource: Resource): Solution = Solution(
        javaResource as
            com.pulumi.azurenative.agfoodplatform.Solution,
    )
}

/**
 * @see [Solution].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Solution].
 */
public suspend fun solution(name: String, block: suspend SolutionResourceBuilder.() -> Unit):
    Solution {
    val builder = SolutionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Solution].
 * @param name The _unique_ name of the resulting resource.
 */
public fun solution(name: String): Solution {
    val builder = SolutionResourceBuilder()
    builder.name(name)
    return builder.build()
}
