@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.agfoodplatform.kotlin.inputs

import com.pulumi.azurenative.agfoodplatform.inputs.DataConnectorPropertiesArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * DataConnector Properties.
 * @property credentials AuthCredentials abstract base class for Auth Purpose.
 */
public data class DataConnectorPropertiesArgs(
    public val credentials: Output<Either<ApiKeyAuthCredentialsArgs, OAuthClientCredentialsArgs>>,
) : ConvertibleToJava<com.pulumi.azurenative.agfoodplatform.inputs.DataConnectorPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.agfoodplatform.inputs.DataConnectorPropertiesArgs =
        com.pulumi.azurenative.agfoodplatform.inputs.DataConnectorPropertiesArgs.builder()
            .credentials(
                credentials.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            ).build()
}

/**
 * Builder for [DataConnectorPropertiesArgs].
 */
@PulumiTagMarker
public class DataConnectorPropertiesArgsBuilder internal constructor() {
    private var credentials: Output<Either<ApiKeyAuthCredentialsArgs, OAuthClientCredentialsArgs>>? =
        null

    /**
     * @param value AuthCredentials abstract base class for Auth Purpose.
     */
    @JvmName("kjsgdtmwbiukegvl")
    public suspend
    fun credentials(`value`: Output<Either<ApiKeyAuthCredentialsArgs, OAuthClientCredentialsArgs>>) {
        this.credentials = value
    }

    /**
     * @param value AuthCredentials abstract base class for Auth Purpose.
     */
    @JvmName("heayimcflyljknqm")
    public suspend
    fun credentials(`value`: Either<ApiKeyAuthCredentialsArgs, OAuthClientCredentialsArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.credentials = mapped
    }

    /**
     * @param value AuthCredentials abstract base class for Auth Purpose.
     */
    @JvmName("duffneqlvoimnjga")
    public fun credentials(`value`: ApiKeyAuthCredentialsArgs) {
        val toBeMapped = Either.ofLeft<ApiKeyAuthCredentialsArgs, OAuthClientCredentialsArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.credentials = mapped
    }

    /**
     * @param value AuthCredentials abstract base class for Auth Purpose.
     */
    @JvmName("amgbattmsquhwevr")
    public fun credentials(`value`: OAuthClientCredentialsArgs) {
        val toBeMapped = Either.ofRight<ApiKeyAuthCredentialsArgs, OAuthClientCredentialsArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.credentials = mapped
    }

    internal fun build(): DataConnectorPropertiesArgs = DataConnectorPropertiesArgs(
        credentials = credentials ?: throw PulumiNullFieldException("credentials"),
    )
}
