@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.agfoodplatform.kotlin.inputs

import com.pulumi.azurenative.agfoodplatform.inputs.GetDataManagerForAgricultureResourcePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dataManagerForAgricultureResourceName DataManagerForAgriculture resource name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetDataManagerForAgricultureResourcePlainArgs(
    public val dataManagerForAgricultureResourceName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.agfoodplatform.inputs.GetDataManagerForAgricultureResourcePlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.agfoodplatform.inputs.GetDataManagerForAgricultureResourcePlainArgs =
        com.pulumi.azurenative.agfoodplatform.inputs.GetDataManagerForAgricultureResourcePlainArgs.builder()
            .dataManagerForAgricultureResourceName(
                dataManagerForAgricultureResourceName.let({ args0 ->
                    args0
                }),
            )
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDataManagerForAgricultureResourcePlainArgs].
 */
@PulumiTagMarker
public class GetDataManagerForAgricultureResourcePlainArgsBuilder internal constructor() {
    private var dataManagerForAgricultureResourceName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value DataManagerForAgriculture resource name.
     */
    @JvmName("qlypawknxarnklvk")
    public suspend fun dataManagerForAgricultureResourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dataManagerForAgricultureResourceName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ywnxxgbteegtxdtn")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetDataManagerForAgricultureResourcePlainArgs =
        GetDataManagerForAgricultureResourcePlainArgs(
            dataManagerForAgricultureResourceName = dataManagerForAgricultureResourceName ?: throw
                PulumiNullFieldException("dataManagerForAgricultureResourceName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
