@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.agfoodplatform.kotlin.inputs

import com.pulumi.azurenative.agfoodplatform.inputs.GetPrivateEndpointConnectionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dataManagerForAgricultureResourceName DataManagerForAgriculture resource name.
 * @property privateEndpointConnectionName Private endpoint connection name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetPrivateEndpointConnectionPlainArgs(
    public val dataManagerForAgricultureResourceName: String,
    public val privateEndpointConnectionName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.agfoodplatform.inputs.GetPrivateEndpointConnectionPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.agfoodplatform.inputs.GetPrivateEndpointConnectionPlainArgs =
        com.pulumi.azurenative.agfoodplatform.inputs.GetPrivateEndpointConnectionPlainArgs.builder()
            .dataManagerForAgricultureResourceName(
                dataManagerForAgricultureResourceName.let({ args0 ->
                    args0
                }),
            )
            .privateEndpointConnectionName(privateEndpointConnectionName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPrivateEndpointConnectionPlainArgs].
 */
@PulumiTagMarker
public class GetPrivateEndpointConnectionPlainArgsBuilder internal constructor() {
    private var dataManagerForAgricultureResourceName: String? = null

    private var privateEndpointConnectionName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value DataManagerForAgriculture resource name.
     */
    @JvmName("fvohkaboxcgkhlsj")
    public suspend fun dataManagerForAgricultureResourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dataManagerForAgricultureResourceName = mapped
    }

    /**
     * @param value Private endpoint connection name.
     */
    @JvmName("xyccfastuduyaqym")
    public suspend fun privateEndpointConnectionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.privateEndpointConnectionName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("uwyjhuymiudnjeck")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetPrivateEndpointConnectionPlainArgs =
        GetPrivateEndpointConnectionPlainArgs(
            dataManagerForAgricultureResourceName = dataManagerForAgricultureResourceName ?: throw
                PulumiNullFieldException("dataManagerForAgricultureResourceName"),
            privateEndpointConnectionName = privateEndpointConnectionName ?: throw
                PulumiNullFieldException("privateEndpointConnectionName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
