@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.alertsmanagement.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [ActionRuleByName].
 */
@PulumiTagMarker
public class ActionRuleByNameResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ActionRuleByNameArgs = ActionRuleByNameArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ActionRuleByNameArgsBuilder.() -> Unit) {
        val builder = ActionRuleByNameArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ActionRuleByName {
        val builtJavaResource =
            com.pulumi.azurenative.alertsmanagement.ActionRuleByName(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ActionRuleByName(builtJavaResource)
    }
}

/**
 * Action rule object containing target scope, conditions and suppression logic
 * Azure REST API version: 2019-05-05-preview. Prior API version in Azure Native 1.x: 2019-05-05-preview.
 * Other available API versions: 2018-11-02-privatepreview.
 * ## Example Usage
 * ### PutActionRule
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var actionRuleByName = new AzureNative.AlertsManagement.ActionRuleByName("actionRuleByName", new()
 *     {
 *         ActionRuleName = "DailySuppression",
 *         Location = "Global",
 *         Properties = new AzureNative.AlertsManagement.Inputs.SuppressionArgs
 *         {
 *             Conditions = new AzureNative.AlertsManagement.Inputs.ConditionsArgs
 *             {
 *                 MonitorCondition = new AzureNative.AlertsManagement.Inputs.ConditionArgs
 *                 {
 *                     Operator = "Equals",
 *                     Values = new[]
 *                     {
 *                         "Fired",
 *                     },
 *                 },
 *                 MonitorService = new AzureNative.AlertsManagement.Inputs.ConditionArgs
 *                 {
 *                     Operator = "Equals",
 *                     Values = new[]
 *                     {
 *                         "Platform",
 *                         "Application Insights",
 *                     },
 *                 },
 *                 Severity = new AzureNative.AlertsManagement.Inputs.ConditionArgs
 *                 {
 *                     Operator = "Equals",
 *                     Values = new[]
 *                     {
 *                         "Sev0",
 *                         "Sev2",
 *                     },
 *                 },
 *                 TargetResourceType = new AzureNative.AlertsManagement.Inputs.ConditionArgs
 *                 {
 *                     Operator = "NotEquals",
 *                     Values = new[]
 *                     {
 *                         "Microsoft.Compute/VirtualMachines",
 *                     },
 *                 },
 *             },
 *             Description = "Action rule on resource group for daily suppression",
 *             Scope = new AzureNative.AlertsManagement.Inputs.ScopeArgs
 *             {
 *                 ScopeType = "ResourceGroup",
 *                 Values = new[]
 *                 {
 *                     "/subscriptions/1e3ff1c0-771a-4119-a03b-be82a51e232d/resourceGroups/alertscorrelationrg",
 *                 },
 *             },
 *             Status = "Enabled",
 *             SuppressionConfig = new AzureNative.AlertsManagement.Inputs.SuppressionConfigArgs
 *             {
 *                 RecurrenceType = "Daily",
 *                 Schedule = new AzureNative.AlertsManagement.Inputs.SuppressionScheduleArgs
 *                 {
 *                     EndDate = "12/18/2018",
 *                     EndTime = "14:00:00",
 *                     StartDate = "12/09/2018",
 *                     StartTime = "06:00:00",
 *                 },
 *             },
 *             Type = "Suppression",
 *         },
 *         ResourceGroupName = "alertscorrelationrg",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/alertsmanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := alertsmanagement.NewActionRuleByName(ctx, "actionRuleByName", &alertsmanagement.ActionRuleByNameArgs{
 * 			ActionRuleName: pulumi.String("DailySuppression"),
 * 			Location:       pulumi.String("Global"),
 * 			Properties: alertsmanagement.Suppression{
 * 				Conditions: alertsmanagement.Conditions{
 * 					MonitorCondition: alertsmanagement.Condition{
 * 						Operator: "Equals",
 * 						Values: []string{
 * 							"Fired",
 * 						},
 * 					},
 * 					MonitorService: alertsmanagement.Condition{
 * 						Operator: "Equals",
 * 						Values: []string{
 * 							"Platform",
 * 							"Application Insights",
 * 						},
 * 					},
 * 					Severity: alertsmanagement.Condition{
 * 						Operator: "Equals",
 * 						Values: []string{
 * 							"Sev0",
 * 							"Sev2",
 * 						},
 * 					},
 * 					TargetResourceType: alertsmanagement.Condition{
 * 						Operator: "NotEquals",
 * 						Values: []string{
 * 							"Microsoft.Compute/VirtualMachines",
 * 						},
 * 					},
 * 				},
 * 				Description: "Action rule on resource group for daily suppression",
 * 				Scope: alertsmanagement.Scope{
 * 					ScopeType: "ResourceGroup",
 * 					Values: []string{
 * 						"/subscriptions/1e3ff1c0-771a-4119-a03b-be82a51e232d/resourceGroups/alertscorrelationrg",
 * 					},
 * 				},
 * 				Status: "Enabled",
 * 				SuppressionConfig: alertsmanagement.SuppressionConfig{
 * 					RecurrenceType: "Daily",
 * 					Schedule: alertsmanagement.SuppressionSchedule{
 * 						EndDate:   "12/18/2018",
 * 						EndTime:   "14:00:00",
 * 						StartDate: "12/09/2018",
 * 						StartTime: "06:00:00",
 * 					},
 * 				},
 * 				Type: "Suppression",
 * 			},
 * 			ResourceGroupName: pulumi.String("alertscorrelationrg"),
 * 			Tags:              nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.alertsmanagement.ActionRuleByName;
 * import com.pulumi.azurenative.alertsmanagement.ActionRuleByNameArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var actionRuleByName = new ActionRuleByName("actionRuleByName", ActionRuleByNameArgs.builder()
 *             .actionRuleName("DailySuppression")
 *             .location("Global")
 *             .properties(Map.ofEntries(
 *                 Map.entry("conditions", Map.ofEntries(
 *                     Map.entry("monitorCondition", Map.ofEntries(
 *                         Map.entry("operator", "Equals"),
 *                         Map.entry("values", "Fired")
 *                     )),
 *                     Map.entry("monitorService", Map.ofEntries(
 *                         Map.entry("operator", "Equals"),
 *                         Map.entry("values",
 *                             "Platform",
 *                             "Application Insights")
 *                     )),
 *                     Map.entry("severity", Map.ofEntries(
 *                         Map.entry("operator", "Equals"),
 *                         Map.entry("values",
 *                             "Sev0",
 *                             "Sev2")
 *                     )),
 *                     Map.entry("targetResourceType", Map.ofEntries(
 *                         Map.entry("operator", "NotEquals"),
 *                         Map.entry("values", "Microsoft.Compute/VirtualMachines")
 *                     ))
 *                 )),
 *                 Map.entry("description", "Action rule on resource group for daily suppression"),
 *                 Map.entry("scope", Map.ofEntries(
 *                     Map.entry("scopeType", "ResourceGroup"),
 *                     Map.entry("values", "/subscriptions/1e3ff1c0-771a-4119-a03b-be82a51e232d/resourceGroups/alertscorrelationrg")
 *                 )),
 *                 Map.entry("status", "Enabled"),
 *                 Map.entry("suppressionConfig", Map.ofEntries(
 *                     Map.entry("recurrenceType", "Daily"),
 *                     Map.entry("schedule", Map.ofEntries(
 *                         Map.entry("endDate", "12/18/2018"),
 *                         Map.entry("endTime", "14:00:00"),
 *                         Map.entry("startDate", "12/09/2018"),
 *                         Map.entry("startTime", "06:00:00")
 *                     ))
 *                 )),
 *                 Map.entry("type", "Suppression")
 *             ))
 *             .resourceGroupName("alertscorrelationrg")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:alertsmanagement:ActionRuleByName DailySuppression /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AlertsManagement/actionRules/{actionRuleName}
 * ```
 */
public class ActionRuleByName internal constructor(
    override val javaResource: com.pulumi.azurenative.alertsmanagement.ActionRuleByName,
) : KotlinCustomResource(javaResource, ActionRuleByNameMapper) {
    /**
     * Resource location
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Azure resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * action rule properties
     */
    public val properties: Output<Any>
        get() = javaResource.properties().applyValue({ args0 -> args0 })

    /**
     * Resource tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Azure resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ActionRuleByNameMapper : ResourceMapper<ActionRuleByName> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.alertsmanagement.ActionRuleByName::class == javaResource::class

    override fun map(javaResource: Resource): ActionRuleByName = ActionRuleByName(
        javaResource as
            com.pulumi.azurenative.alertsmanagement.ActionRuleByName,
    )
}

/**
 * @see [ActionRuleByName].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ActionRuleByName].
 */
public suspend fun actionRuleByName(
    name: String,
    block: suspend ActionRuleByNameResourceBuilder.() -> Unit,
): ActionRuleByName {
    val builder = ActionRuleByNameResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ActionRuleByName].
 * @param name The _unique_ name of the resulting resource.
 */
public fun actionRuleByName(name: String): ActionRuleByName {
    val builder = ActionRuleByNameResourceBuilder()
    builder.name(name)
    return builder.build()
}
