@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.alertsmanagement.kotlin.inputs

import com.pulumi.azurenative.alertsmanagement.inputs.AlertProcessingRulePropertiesArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Alert processing rule properties defining scopes, conditions and scheduling logic for alert processing rule.
 * @property actions Actions to be applied.
 * @property conditions Conditions on which alerts will be filtered.
 * @property description Description of alert processing rule.
 * @property enabled Indicates if the given alert processing rule is enabled or disabled.
 * @property schedule Scheduling for alert processing rule.
 * @property scopes Scopes on which alert processing rule will apply.
 */
public data class AlertProcessingRulePropertiesArgs(
    public val actions: Output<List<Either<AddActionGroupsArgs, RemoveAllActionGroupsArgs>>>,
    public val conditions: Output<List<ConditionArgs>>? = null,
    public val description: Output<String>? = null,
    public val enabled: Output<Boolean>? = null,
    public val schedule: Output<ScheduleArgs>? = null,
    public val scopes: Output<List<String>>,
) :
    ConvertibleToJava<com.pulumi.azurenative.alertsmanagement.inputs.AlertProcessingRulePropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.alertsmanagement.inputs.AlertProcessingRulePropertiesArgs =
        com.pulumi.azurenative.alertsmanagement.inputs.AlertProcessingRulePropertiesArgs.builder()
            .actions(
                actions.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 ->
                            args0.let({ args0 -> args0.toJava() })
                        }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                    })
                }),
            )
            .conditions(
                conditions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .schedule(schedule?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .scopes(scopes.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [AlertProcessingRulePropertiesArgs].
 */
@PulumiTagMarker
public class AlertProcessingRulePropertiesArgsBuilder internal constructor() {
    private var actions: Output<List<Either<AddActionGroupsArgs, RemoveAllActionGroupsArgs>>>? = null

    private var conditions: Output<List<ConditionArgs>>? = null

    private var description: Output<String>? = null

    private var enabled: Output<Boolean>? = null

    private var schedule: Output<ScheduleArgs>? = null

    private var scopes: Output<List<String>>? = null

    /**
     * @param value Actions to be applied.
     */
    @JvmName("wgwdbbxjfpyvrfso")
    public suspend
    fun actions(`value`: Output<List<Either<AddActionGroupsArgs, RemoveAllActionGroupsArgs>>>) {
        this.actions = value
    }

    @JvmName("bygyshdwckxyutwl")
    public suspend fun actions(
        vararg
        values: Output<Either<AddActionGroupsArgs, RemoveAllActionGroupsArgs>>,
    ) {
        this.actions = Output.all(values.asList())
    }

    /**
     * @param values Actions to be applied.
     */
    @JvmName("qukarjkkckrxtotm")
    public suspend
    fun actions(values: List<Output<Either<AddActionGroupsArgs, RemoveAllActionGroupsArgs>>>) {
        this.actions = Output.all(values)
    }

    /**
     * @param value Conditions on which alerts will be filtered.
     */
    @JvmName("fnamcdkjgcjfrluc")
    public suspend fun conditions(`value`: Output<List<ConditionArgs>>) {
        this.conditions = value
    }

    @JvmName("ixlsmunitkegihhw")
    public suspend fun conditions(vararg values: Output<ConditionArgs>) {
        this.conditions = Output.all(values.asList())
    }

    /**
     * @param values Conditions on which alerts will be filtered.
     */
    @JvmName("xvitwpnxqjdgtdjf")
    public suspend fun conditions(values: List<Output<ConditionArgs>>) {
        this.conditions = Output.all(values)
    }

    /**
     * @param value Description of alert processing rule.
     */
    @JvmName("apwkxowhdpfvjpdu")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Indicates if the given alert processing rule is enabled or disabled.
     */
    @JvmName("xaguujtajxmobxec")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Scheduling for alert processing rule.
     */
    @JvmName("qvjkssimkctkgwqr")
    public suspend fun schedule(`value`: Output<ScheduleArgs>) {
        this.schedule = value
    }

    /**
     * @param value Scopes on which alert processing rule will apply.
     */
    @JvmName("dugyusfaamawhvfr")
    public suspend fun scopes(`value`: Output<List<String>>) {
        this.scopes = value
    }

    @JvmName("qbwsdasubnqtwxnr")
    public suspend fun scopes(vararg values: Output<String>) {
        this.scopes = Output.all(values.asList())
    }

    /**
     * @param values Scopes on which alert processing rule will apply.
     */
    @JvmName("oevebbbkgtarcsky")
    public suspend fun scopes(values: List<Output<String>>) {
        this.scopes = Output.all(values)
    }

    /**
     * @param value Actions to be applied.
     */
    @JvmName("jsjfrcineejvsinf")
    public suspend
    fun actions(`value`: List<Either<AddActionGroupsArgs, RemoveAllActionGroupsArgs>>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actions = mapped
    }

    /**
     * @param values Actions to be applied.
     */
    @JvmName("iusmvkapfviiiqhx")
    public suspend fun actions(
        vararg
        values: Either<AddActionGroupsArgs, RemoveAllActionGroupsArgs>,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actions = mapped
    }

    /**
     * @param value Conditions on which alerts will be filtered.
     */
    @JvmName("hgnbntccfkvrehat")
    public suspend fun conditions(`value`: List<ConditionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.conditions = mapped
    }

    /**
     * @param argument Conditions on which alerts will be filtered.
     */
    @JvmName("swwmraxajopbjbix")
    public suspend fun conditions(argument: List<suspend ConditionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { ConditionArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.conditions = mapped
    }

    /**
     * @param argument Conditions on which alerts will be filtered.
     */
    @JvmName("ipbgsegdfphkfxsj")
    public suspend fun conditions(vararg argument: suspend ConditionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { ConditionArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.conditions = mapped
    }

    /**
     * @param argument Conditions on which alerts will be filtered.
     */
    @JvmName("hhrybcspohevdjwx")
    public suspend fun conditions(argument: suspend ConditionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ConditionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.conditions = mapped
    }

    /**
     * @param values Conditions on which alerts will be filtered.
     */
    @JvmName("jrkkbohubkyuggnq")
    public suspend fun conditions(vararg values: ConditionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.conditions = mapped
    }

    /**
     * @param value Description of alert processing rule.
     */
    @JvmName("jtujhtdmwtuhmqnb")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Indicates if the given alert processing rule is enabled or disabled.
     */
    @JvmName("gwyndskkxadqeslb")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Scheduling for alert processing rule.
     */
    @JvmName("wfynkhcosejjfoqu")
    public suspend fun schedule(`value`: ScheduleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schedule = mapped
    }

    /**
     * @param argument Scheduling for alert processing rule.
     */
    @JvmName("lhvjfyiyxqgpysqs")
    public suspend fun schedule(argument: suspend ScheduleArgsBuilder.() -> Unit) {
        val toBeMapped = ScheduleArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.schedule = mapped
    }

    /**
     * @param value Scopes on which alert processing rule will apply.
     */
    @JvmName("jxbstodsghxwsvqo")
    public suspend fun scopes(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scopes = mapped
    }

    /**
     * @param values Scopes on which alert processing rule will apply.
     */
    @JvmName("hgllabqwkiitokhe")
    public suspend fun scopes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scopes = mapped
    }

    internal fun build(): AlertProcessingRulePropertiesArgs = AlertProcessingRulePropertiesArgs(
        actions = actions ?: throw PulumiNullFieldException("actions"),
        conditions = conditions,
        description = description,
        enabled = enabled,
        schedule = schedule,
        scopes = scopes ?: throw PulumiNullFieldException("scopes"),
    )
}
