@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.alertsmanagement.kotlin.inputs

import com.pulumi.azurenative.alertsmanagement.inputs.DailyRecurrenceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Daily recurrence object.
 * @property endTime End time for recurrence.
 * @property recurrenceType Specifies when the recurrence should be applied.
 * Expected value is 'Daily'.
 * @property startTime Start time for recurrence.
 */
public data class DailyRecurrenceArgs(
    public val endTime: Output<String>,
    public val recurrenceType: Output<String>,
    public val startTime: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.alertsmanagement.inputs.DailyRecurrenceArgs> {
    override fun toJava(): com.pulumi.azurenative.alertsmanagement.inputs.DailyRecurrenceArgs =
        com.pulumi.azurenative.alertsmanagement.inputs.DailyRecurrenceArgs.builder()
            .endTime(endTime.applyValue({ args0 -> args0 }))
            .recurrenceType(recurrenceType.applyValue({ args0 -> args0 }))
            .startTime(startTime.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DailyRecurrenceArgs].
 */
@PulumiTagMarker
public class DailyRecurrenceArgsBuilder internal constructor() {
    private var endTime: Output<String>? = null

    private var recurrenceType: Output<String>? = null

    private var startTime: Output<String>? = null

    /**
     * @param value End time for recurrence.
     */
    @JvmName("dopbdmaexeqtgvqf")
    public suspend fun endTime(`value`: Output<String>) {
        this.endTime = value
    }

    /**
     * @param value Specifies when the recurrence should be applied.
     * Expected value is 'Daily'.
     */
    @JvmName("kvhpvymgvpsufgmo")
    public suspend fun recurrenceType(`value`: Output<String>) {
        this.recurrenceType = value
    }

    /**
     * @param value Start time for recurrence.
     */
    @JvmName("frrkyyqmmooshkov")
    public suspend fun startTime(`value`: Output<String>) {
        this.startTime = value
    }

    /**
     * @param value End time for recurrence.
     */
    @JvmName("rsemhyubodevrifq")
    public suspend fun endTime(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endTime = mapped
    }

    /**
     * @param value Specifies when the recurrence should be applied.
     * Expected value is 'Daily'.
     */
    @JvmName("qskqtfcdfrkdiidg")
    public suspend fun recurrenceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recurrenceType = mapped
    }

    /**
     * @param value Start time for recurrence.
     */
    @JvmName("xafphwwdbubcfeia")
    public suspend fun startTime(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.startTime = mapped
    }

    internal fun build(): DailyRecurrenceArgs = DailyRecurrenceArgs(
        endTime = endTime ?: throw PulumiNullFieldException("endTime"),
        recurrenceType = recurrenceType ?: throw PulumiNullFieldException("recurrenceType"),
        startTime = startTime ?: throw PulumiNullFieldException("startTime"),
    )
}
