@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.alertsmanagement.kotlin.inputs

import com.pulumi.azurenative.alertsmanagement.inputs.DetectorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The detector information. By default this is not populated, unless it's specified in expandDetector
 * @property id The detector id.
 * @property parameters The detector's parameters.'
 */
public data class DetectorArgs(
    public val id: Output<String>,
    public val parameters: Output<Map<String, Any>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.alertsmanagement.inputs.DetectorArgs> {
    override fun toJava(): com.pulumi.azurenative.alertsmanagement.inputs.DetectorArgs =
        com.pulumi.azurenative.alertsmanagement.inputs.DetectorArgs.builder()
            .id(id.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [DetectorArgs].
 */
@PulumiTagMarker
public class DetectorArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var parameters: Output<Map<String, Any>>? = null

    /**
     * @param value The detector id.
     */
    @JvmName("lfcluirxqplhaeqv")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The detector's parameters.'
     */
    @JvmName("xtwyshsmionpblml")
    public suspend fun parameters(`value`: Output<Map<String, Any>>) {
        this.parameters = value
    }

    /**
     * @param value The detector id.
     */
    @JvmName("cpmfivkfhpgwvvka")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The detector's parameters.'
     */
    @JvmName("duttimyreclwustt")
    public suspend fun parameters(`value`: Map<String, Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param values The detector's parameters.'
     */
    @JvmName("alcyoxrlkwvekjax")
    public fun parameters(vararg values: Pair<String, Any>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    internal fun build(): DetectorArgs = DetectorArgs(
        id = id ?: throw PulumiNullFieldException("id"),
        parameters = parameters,
    )
}
